/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class NoDuplicatesCollection<T>
implements Collection<T>,
Cloneable {
    private LinkedList<T> linkedList;

    public NoDuplicatesCollection() {
        this.linkedList = new LinkedList();
    }

    public NoDuplicatesCollection(Collection<T> c) {
        if (c == null) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o recebida n\u00e3o pode ser nula.");
        }
        this.linkedList = new LinkedList<T>(c);
    }

    @Override
    public int size() {
        return this.linkedList.size();
    }

    @Override
    public void clear() {
        this.linkedList.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.linkedList.toArray();
    }

    public Object getFirst() throws NoSuchElementException {
        return this.linkedList.getFirst();
    }

    public Object getLast() throws NoSuchElementException {
        return this.linkedList.getLast();
    }

    @Override
    public boolean add(T o) {
        if (o == null) {
            throw new IllegalArgumentException("Essa cole\u00e7\u00e3o n\u00e3o aceita elementos nulos.");
        }
        if (this.linkedList.contains(o)) {
            if (this.linkedList.indexOf(o) == this.linkedList.size() - 1) {
                return false;
            }
            this.linkedList.remove(o);
        }
        return this.linkedList.add(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.linkedList.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.linkedList.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o recebida n\u00e3o pode ser nula.");
        }
        boolean wasChanged = false;
        for (T element : c) {
            if (!this.add(element)) continue;
            wasChanged = true;
        }
        return wasChanged;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.linkedList.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.linkedList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this.linkedList.iterator();
    }

    public NoDuplicatesCollection<T> clone() {
        return new NoDuplicatesCollection<T>(this.linkedList);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NoDuplicatesCollection)) {
            return false;
        }
        NoDuplicatesCollection other = (NoDuplicatesCollection)obj;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator<T> iterator = this.iterator();
        Iterator<T> otherIterator = other.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.linkedList.hashCode();
    }

    public String toString() {
        return this.linkedList.toString();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.linkedList.toArray(a);
    }
}

