/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.messages;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID id;
    private long creationDate;
    private TimeZone timeZone;
    private Map<String, Serializable> headers;
    private Serializable body;

    public Message(Serializable body) {
        this.setBody(body);
        this.creationDate = System.currentTimeMillis();
        this.timeZone = TimeZone.getDefault();
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        if (null == id) {
            throw new IllegalArgumentException("id == null");
        }
        this.id = id;
    }

    public synchronized Serializable getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public synchronized boolean containsHeader(String name) {
        return this.headers != null && this.headers.containsKey(name);
    }

    public synchronized void setHeader(String name, Serializable value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Serializable>();
        }
        this.headers.put(name, value);
    }

    public Serializable getBody() {
        return this.body;
    }

    public void setBody(Serializable body) {
        if (null == body) {
            throw new IllegalArgumentException("body == null");
        }
        this.body = body;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

