/*
 * Decompiled with CFR 0.152.
 */
package validations;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import validations.AbstractValidation;
import validations.ValidationException;
import validations.util.ValidatorUtils;

public class PrjLockedInfoValidation
extends AbstractValidation {
    private static String TARGET_FILE = "locked_projects.csbase";
    private File targetFile;
    private File backupFile;
    private List<String> lines;

    @Override
    protected boolean init() {
        File projectDir = this.getProjectDir();
        if (projectDir != null) {
            this.targetFile = new File(projectDir, TARGET_FILE);
            this.backupFile = new File(this.getBackupDirPath() + "/" + TARGET_FILE);
        }
        return true;
    }

    @Override
    protected String getStartMessage() {
        return "Convertendo informa\u00e7\u00f5es sobre projetos bloqueados.";
    }

    @Override
    protected boolean runsOnlyOnce() {
        return true;
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status inputStatus, List<String> errors) {
        switch (inputStatus) {
            case VALIDATION_FAILED: {
                errors.add("Erro na valida\u00e7\u00e3o do arquivo de projetos bloqueados.");
                break;
            }
            case PATCH_FAILED: {
                errors.add("Erro na convers\u00e3o do arquivo de projetos bloqueados.");
                break;
            }
            default: {
                errors.add("Estado inv\u00e1lido: " + inputStatus.toString());
            }
        }
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status inputStatus) {
        switch (inputStatus) {
            case VALIDATION_OK: {
                return "N\u00e3o h\u00e1 convers\u00f5es a fazer.";
            }
            case PATCH_OK: {
                return "Informa\u00e7\u00f5es convertidas.";
            }
        }
        return "Estado inv\u00e1lido: " + inputStatus.toString();
    }

    @Override
    protected boolean validate() throws ValidationException {
        if (this.targetFile == null || !this.targetFile.exists()) {
            return true;
        }
        this.lines = new ArrayList<String>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(this.targetFile));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (!line.endsWith(";")) {
                    if (!line.endsWith("/")) {
                        throw new ValidationException("Arquivo inv\u00e1lido: detectada linha com formato inv\u00e1lido: [" + line + "]");
                    }
                    line = line.replaceFirst("/", "#");
                    line = line.replace("/", ";");
                    line = line.replaceFirst("#", "/");
                } else {
                    this.logger.log(Level.INFO, "Linha j\u00e1 convertida: " + line);
                }
                this.lines.add(line);
            }
            in.close();
        }
        catch (IOException e) {
            throw new ValidationException("Falha de I/O.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    String err = "Falha de I/O no fechamento do arquivo.";
                    throw new ValidationException("Falha de I/O no fechamento do arquivo.", e);
                }
            }
        }
        return this.lines.size() == 0;
    }

    @Override
    protected boolean backupData() {
        return ValidatorUtils.copyFile(this.targetFile, this.backupFile, this.logger, false);
    }

    @Override
    protected boolean restoreBackup() {
        return ValidatorUtils.copyFile(this.backupFile, this.targetFile, this.logger, false);
    }

    @Override
    protected boolean applyPatch() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.targetFile));
            for (String line : this.lines) {
                out.write(line);
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    protected void finish() {
    }
}

