/*
 * Decompiled with CFR 0.152.
 */
package csbase.fogbow.client.authentication;

import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.exception.AuthenticationException;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.http.HTTPConnection;
import cz.cesnet.cloud.occi.api.http.HTTPHelper;
import cz.cesnet.cloud.occi.api.http.auth.HTTPAuthentication;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAuthTokenAuthentication
extends HTTPAuthentication {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAuthTokenAuthentication.class);
    private String token;

    public XAuthTokenAuthentication(String tokenFilePath) {
        try {
            this.token = this.readToken(tokenFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void authenticate() throws CommunicationException {
        HTTPConnection connection = this.getConnection();
        BasicHeader vomsProxyHeader = new BasicHeader("X-Auth-Token", this.token);
        connection.addHeader((Header)vomsProxyHeader);
        SSLContext sslContext = this.createSSLContext();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        LOGGER.debug("Running authentication...");
        try {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
            HttpClientBuilder builder = HttpClients.custom().setDefaultCredentialsProvider(this.getCredentialsProvider()).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(defaultRequestConfig);
            if (LOGGER.isDebugEnabled()) {
                builder.disableContentCompression();
            }
            CloseableHttpClient client = builder.build();
            connection.setClient(client);
            HttpGet httpGet = HTTPHelper.prepareGet((String)"/-/", (Header[])connection.getHeaders());
            try (CloseableHttpResponse response = connection.getClient().execute(this.getTarget(), (HttpRequest)httpGet, connection.getContext());){
                if (response.getStatusLine().getStatusCode() != 200) {
                    if (response.getEntity() == null) {
                        LOGGER.error("Response: {}\nHeaders: {}\nBody:\n", (Object)response.getStatusLine().toString(), (Object)response.getAllHeaders());
                    } else {
                        LOGGER.error("Response: {}\nHeaders: {}\nBody: {}", new Object[]{response.getStatusLine().toString(), response.getAllHeaders(), EntityUtils.toString((HttpEntity)response.getEntity())});
                    }
                    throw new AuthenticationException(response.getStatusLine().toString());
                }
                LOGGER.debug("Successful authentication!");
            }
        }
        catch (IOException ex) {
            throw new CommunicationException((Throwable)ex);
        }
    }

    public String getIdentifier() {
        return null;
    }

    public Authentication getFallback() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readToken(String certificatePath) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(certificatePath));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }
}

