/*
 * Decompiled with CFR 0.152.
 */
package csbase.fogbow.client.example;

import csbase.fogbow.client.OcciClient;
import csbase.fogbow.client.authentication.XAuthTokenAuthentication;
import csbase.fogbow.client.model.Instance;
import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.exception.EntityBuildingException;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class OpenStackUsage {
    public static void main(String[] args) throws CommunicationException, AmbiguousIdentifierException, IOException, EntityBuildingException, InvalidAttributeException, InvalidAttributeValueException, URISyntaxException {
        XAuthTokenAuthentication authentication = new XAuthTokenAuthentication("/Users/jforny/Desktop/token");
        OcciClient client = new OcciClient(URI.create("http://localhost:8787"), (Authentication)authentication);
        client.listFlavors();
        client.listImages();
        String publicKey = OpenStackUsage.readFile("/Users/jforny/.ssh/id_rsa.pub");
        Mixin image = new Mixin(new URI("http://schemas.openstack.org/template/os#"), "1bfd6b4f-dd35-4568-937b-b7168f0568f3");
        Mixin flavor = new Mixin(new URI("http://schemas.openstack.org/template/resource#"), "m1-small");
        OcciClient.onInstanceCreateListener runJob = new OcciClient.onInstanceCreateListener(){

            @Override
            public void onInstanceCreate(Instance instance) {
                System.out.println("onInstanceCreate");
                System.out.println("SSH Address: " + instance.getSshPublicAddress());
            }
        };
        Future<Instance> task = client.createInstance(flavor, image, null, publicKey, runJob);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFile(String certificatePath) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(certificatePath));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            String string = sb.toString().trim();
            return string;
        }
    }

    private static void configureLog() {
        ConsoleAppender console = new ConsoleAppender();
        String PATTERN = "%d [%p|%c|%C{1}] %m%n";
        console.setLayout((Layout)new PatternLayout(PATTERN));
        console.setThreshold((Priority)Level.ALL);
        console.activateOptions();
        Logger.getRootLogger().addAppender((Appender)console);
    }
}

