/*
 * Decompiled with CFR 0.152.
 */
package csbase.fogbow.client.model;

import java.lang.reflect.Field;

public class Member {
    private String id;
    private Integer cpuIdle;
    private Integer cpuInUse;
    private Integer memIdle;
    private Integer memInUse;
    private Integer instancesIdle;
    private Integer instancesInUse;

    public Member(String id, String quotas) {
        this.id = id;
        try {
            this.parseQuotas(quotas);
        }
        catch (IllegalAccessException e) {
            System.err.println("Error building member: " + id);
            e.printStackTrace();
        }
    }

    private void parseQuotas(String memberQuota) throws IllegalAccessException {
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Integer memberIndex = memberQuota.indexOf(field.getName());
            if (memberIndex == -1) continue;
            Integer newLineIndex = memberQuota.indexOf("\n", (int)memberIndex);
            String fieldValue = newLineIndex != -1 ? memberQuota.substring(memberIndex + field.getName().length() + 1, newLineIndex) : memberQuota.substring(memberIndex + field.getName().length() + 1);
            field.set(this, Integer.valueOf(fieldValue));
        }
    }

    public Integer getInstancesInUse() {
        return this.instancesInUse;
    }

    public void setInstancesInUse(Integer instancesInUse) {
        this.instancesInUse = instancesInUse;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCpuIdle() {
        return this.cpuIdle;
    }

    public void setCpuIdle(Integer cpuIdle) {
        this.cpuIdle = cpuIdle;
    }

    public Integer getCpuInUse() {
        return this.cpuInUse;
    }

    public void setCpuInUse(Integer cpuInUse) {
        this.cpuInUse = cpuInUse;
    }

    public Integer getMemIdle() {
        return this.memIdle;
    }

    public void setMemIdle(Integer memIdle) {
        this.memIdle = memIdle;
    }

    public Integer getMemInUse() {
        return this.memInUse;
    }

    public void setMemInUse(Integer memInUse) {
        this.memInUse = memInUse;
    }

    public Integer getInstancesIdle() {
        return this.instancesIdle;
    }

    public void setInstancesIdle(Integer instanceIdle) {
        this.instancesIdle = instanceIdle;
    }

    public String toString() {
        StringBuilder obj = new StringBuilder();
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                obj.append(field.getName() + ": " + field.get(this) + "\n");
            }
            catch (IllegalAccessException e) {
                obj.append(field.getName() + ": Not accessible");
                e.printStackTrace();
            }
        }
        return obj.toString();
    }
}

