package Requests.Jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Map;

/**
 * JobInfo
 */
public class JobInfo {
  private String jobId = null;

  private String groupId = null;

  private String sessionId = null;

  /**
   * If the job was submit by the REST service or by RMI service.
   */
  public enum SubmitedByEnum {
    REST_SERVICE("REST Service"),
    RMI_SERVICE("RMI Service");
    private String value;
    SubmitedByEnum(String value) {
      this.value = value;
    }
    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  public enum StatusType {
    SCHEDULED("SCHEDULED"),
    INIT("INIT"),
    UPLOADING("UPLOADING"),
    QUEUED("QUEUED"),
    EXECUTING("EXECUTING"),
    DOWNLOADING("DOWNLOADING"),
    FINISHED("FINISHED"),
    UNKNOWN("UNKNOWN");
    private String value;

    StatusType(String value) {
      this.value = value;
    }
    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  private SubmitedByEnum submitedBy = null;

  private String projectId = null;

  private String algorithmId = null;

  private String algorithmVersion = null;

  private String algorithmName = null;

  private String jobOwner = null;

  private String jobOwnerName = null;

  private Boolean automaticallyMachineSelection = null;

  private String submissionMachine = null;

  private String submissionTime = null;

  private String executionMachine = null;

  private String endTime = null;

  private Integer numberOfAttempts = null;

  private String description = null;

  private Integer priority = null;

  private StatusType state = null;

  private Integer exitCode = null;

  /**
   * The status describing the end of the execution. It can be empty if the job
   * have not already finished.
   */
  public enum ExitStatusEnum {
    UNKNOWN("unknown"),

    SUCCESS("success"),

    EXECUTION_ERROR("execution_error"),

    JOB_IDENTIFIER_NOT_FOUND("job_identifier_not_found"),

    UNEXPECTED_MACHINE_ERROR("unexpected_machine_error"),

    PROJECT_NOT_FOUND("project_not_found"),

    FAILED_SETUP_EXECUTION_ENVIRONMENT("failed_setup_execution_environment"),

    NO_PERMISSION("no_permission"),

    NO_MACHINE_AVAILABLE("no_machine_available"),

    KILLED("killed"),

    LOST("lost"),

    UNDEFINED("undefined");

    private String value;

    ExitStatusEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  private ExitStatusEnum exitStatus = null;
  private Double cpuTime = null;
  private Integer wallclockTime = null;
  private Double ramMemory = null;
  private String progressInfo = null;
  private List<StatusChangeHistory> statusHistory = new ArrayList<StatusChangeHistory>();
  private String lastModifiedTime = null;
  private List<MonitoredFile> monitoredFiles = new ArrayList<MonitoredFile>();
  private Map<String, String> specificData = new HashMap<String, String>();

  public JobInfo jobId(String jobId) {
    this.jobId = jobId;
    return this;
  }

  /**
   * The job Id.
   *
   * @return jobId
   **/
  public String getJobId() {
    return jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = jobId;
  }

  public JobInfo groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * The group Id of the job.
   *
   * @return groupId
   **/
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public JobInfo sessionId(String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

  /**
   * The session Id used for job submission. By default, the sessionId is the
   * project Id.
   *
   * @return sessionId
   **/
  public String getSessionId() {
    return sessionId;
  }

  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  public JobInfo submitedBy(SubmitedByEnum submitedBy) {
    this.submitedBy = submitedBy;
    return this;
  }

  /**
   * If the job was submit by the REST service or by RMI service.
   *
   * @return submitedBy
   **/
  public SubmitedByEnum getSubmitedBy() {
    return submitedBy;
  }

  public void setSubmitedBy(SubmitedByEnum submitedBy) {
    this.submitedBy = submitedBy;
  }

  public JobInfo projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The project Id associated with the job.
   *
   * @return projectId
   **/
  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public JobInfo algorithmId(String algorithmId) {
    this.algorithmId = algorithmId;
    return this;
  }

  /**
   * The algorithm Id associated with the job.
   *
   * @return algorithmId
   **/
  public String getAlgorithmId() {
    return algorithmId;
  }

  public void setAlgorithmId(String algorithmId) {
    this.algorithmId = algorithmId;
  }

  public JobInfo algorithmVersion(String algorithmVersion) {
    this.algorithmVersion = algorithmVersion;
    return this;
  }

  /**
   * The algoritm version associated with the job.
   *
   * @return algorithmVersion
   **/
  public String getAlgorithmVersion() {
    return algorithmVersion;
  }

  public void setAlgorithmVersion(String algorithmVersion) {
    this.algorithmVersion = algorithmVersion;
  }

  public JobInfo algorithmName(String algorithmName) {
    this.algorithmName = algorithmName;
    return this;
  }

  /**
   * The algoritm name associated with the job.
   *
   * @return algorithmName
   **/
  public String getAlgorithmName() {
    return algorithmName;
  }

  public void setAlgorithmName(String algorithmName) {
    this.algorithmName = algorithmName;
  }

  public JobInfo jobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
    return this;
  }

  /**
   * The id of the user who submitted the job.
   *
   * @return jobOwner
   **/
  public String getJobOwner() {
    return jobOwner;
  }

  public void setJobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
  }

  public JobInfo jobOwnerName(String jobOwnerName) {
    this.jobOwnerName = jobOwnerName;
    return this;
  }

  /**
   * The name of the user who submitted the job.
   *
   * @return jobOwnerName
   **/
  public String getJobOwnerName() {
    return jobOwnerName;
  }

  public void setJobOwnerName(String jobOwnerName) {
    this.jobOwnerName = jobOwnerName;
  }

  public JobInfo automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
    return this;
  }

  /**
   * If the user select a machine for execution or not.
   *
   * @return automaticallyMachineSelection
   **/
  public Boolean getAutomaticallyMachineSelection() {
    return automaticallyMachineSelection;
  }

  public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
  }

  public JobInfo submissionMachine(String submissionMachine) {
    this.submissionMachine = submissionMachine;
    return this;
  }

  /**
   * The machine selected for job execution. If the user choose the
   * automatically machine selection, this information is empty.
   *
   * @return submissionMachine
   **/
  public String getSubmissionMachine() {
    return submissionMachine;
  }

  public void setSubmissionMachine(String submissionMachine) {
    this.submissionMachine = submissionMachine;
  }

  public JobInfo submissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
    return this;
  }

  /**
   * The submission time.
   *
   * @return submissionTime
   **/
  public String getSubmissionTime() {
    return submissionTime;
  }

  public void setSubmissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
  }

  public JobInfo executionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
    return this;
  }

  /**
   * The machine where the job executed (or was scheduled to execute).
   *
   * @return executionMachine
   **/
  public String getExecutionMachine() {
    return executionMachine;
  }

  public void setExecutionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
  }

  public JobInfo endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The end time of the execution. It can be empty if the job have not already
   * finished.
   *
   * @return endTime
   **/
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public JobInfo numberOfAttempts(Integer numberOfAttempts) {
    this.numberOfAttempts = numberOfAttempts;
    return this;
  }

  /**
   * The number of times the job has already been scheduled for execution.
   *
   * @return numberOfAttempts
   **/
  public Integer getNumberOfAttempts() {
    return numberOfAttempts;
  }

  public void setNumberOfAttempts(Integer numberOfAttempts) {
    this.numberOfAttempts = numberOfAttempts;
  }

  public JobInfo description(String description) {
    this.description = description;
    return this;
  }

  /**
   * The description provided by the user at submission. It can be empty.
   *
   * @return description
   **/
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public JobInfo priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority of the job.
   *
   * @return priority
   **/
  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  public JobInfo state(StatusType state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   *
   * @return state
   **/
  public StatusType getState() {
    return state;
  }

  public void setState(StatusType state) {
    this.state = state;
  }

  public JobInfo exitCode(Integer exitCode) {
    this.exitCode = exitCode;
    return this;
  }

  /**
   * The code returned by the job execution. It can be empty if the job have not
   * already finished or if the system could not gather it.
   *
   * @return exitCode
   **/
  public Integer getExitCode() {
    return exitCode;
  }

  public void setExitCode(Integer exitCode) {
    this.exitCode = exitCode;
  }

  public JobInfo exitStatus(ExitStatusEnum exitStatus) {
    this.exitStatus = exitStatus;
    return this;
  }

  /**
   * The status describing the end of the execution. It can be empty if the job
   * have not already finished.
   *
   * @return exitStatus
   **/
  public ExitStatusEnum getExitStatus() {
    return exitStatus;
  }

  public void setExitStatus(ExitStatusEnum exitStatus) {
    this.exitStatus = exitStatus;
  }

  public JobInfo cpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
    return this;
  }

  /**
   * Get cpuTime
   *
   * @return cpuTime
   **/
  public Double getCpuTime() {
    return cpuTime;
  }

  public void setCpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
  }

  public JobInfo wallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
    return this;
  }

  /**
   * Get wallclockTime
   *
   * @return wallclockTime
   **/
  public Integer getWallclockTime() {
    return wallclockTime;
  }

  public void setWallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
  }

  public JobInfo ramMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
    return this;
  }

  /**
   * Get ramMemory
   *
   * @return ramMemory
   **/
  public Double getRamMemory() {
    return ramMemory;
  }

  public void setRamMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
  }

  public JobInfo progressInfo(String progressInfo) {
    this.progressInfo = progressInfo;
    return this;
  }

  /**
   * The progress info about a job.
   *
   **/
  public void setProgressInfo(String progressInfo) {
    this.progressInfo = progressInfo;
  }

  public JobInfo statusHistory(List<StatusChangeHistory> statusHistory) {
    this.statusHistory = statusHistory;
    return this;
  }

  public JobInfo addStatusHistoryItem(StatusChangeHistory statusHistoryItem) {
    this.statusHistory.add(statusHistoryItem);
    return this;
  }

  /**
   * Get statusHistory
   *
   * @return statusHistory
   **/
  public List<StatusChangeHistory> getStatusHistory() {
    return statusHistory;
  }

  public void setStatusHistory(List<StatusChangeHistory> statusHistory) {
    this.statusHistory = statusHistory;
  }

  public JobInfo lastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The time of job last modification.
   *
   * @return lastModifiedTime
   **/
  public String getLastModifiedTime() {
    return lastModifiedTime;
  }

  public void setLastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
  }

  public JobInfo monitoredFiles(List<MonitoredFile> monitoredFiles) {
    this.monitoredFiles = monitoredFiles;
    return this;
  }

  public JobInfo addMonitoredFilesItem(MonitoredFile monitoredFilesItem) {
    this.monitoredFiles.add(monitoredFilesItem);
    return this;
  }

  /**
   * Monitored files during the job's execution
   *
   * @return monitoredFiles
   **/
  public List<MonitoredFile> getMonitoredFiles() {
    return monitoredFiles;
  }

  public void setMonitoredFiles(List<MonitoredFile> monitoredFiles) {
    this.monitoredFiles = monitoredFiles;
  }

  public JobInfo specificData(Map<String, String> specificData) {
    this.specificData = specificData;
    return this;
  }

  public JobInfo putSpecificDataItem(String key, String specificDataItem) {
    this.specificData.put(key, specificDataItem);
    return this;
  }

  /**
   * Specific data monitored during the job's execution
   *
   * @return specificData
   **/
  public Map<String, String> getSpecificData() {
    return specificData;
  }

  public void setSpecificData(Map<String, String> specificData) {
    this.specificData = specificData;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobInfo job = (JobInfo) o;
    return Objects.equals(this.jobId, job.jobId) &&
        Objects.equals(this.groupId, job.groupId) &&
        Objects.equals(this.sessionId, job.sessionId) &&
        Objects.equals(this.submitedBy, job.submitedBy) &&
        Objects.equals(this.projectId, job.projectId) &&
        Objects.equals(this.algorithmId, job.algorithmId) &&
        Objects.equals(this.algorithmVersion, job.algorithmVersion) &&
        Objects.equals(this.algorithmName, job.algorithmName) &&
        Objects.equals(this.jobOwner, job.jobOwner) &&
        Objects.equals(this.jobOwnerName, job.jobOwnerName) &&
        Objects.equals(this.automaticallyMachineSelection, job.automaticallyMachineSelection) &&
        Objects.equals(this.submissionMachine, job.submissionMachine) &&
        Objects.equals(this.submissionTime, job.submissionTime) &&
        Objects.equals(this.executionMachine, job.executionMachine) &&
        Objects.equals(this.endTime, job.endTime) &&
        Objects.equals(this.numberOfAttempts, job.numberOfAttempts) &&
        Objects.equals(this.description, job.description) &&
        Objects.equals(this.priority, job.priority) &&
        Objects.equals(this.state, job.state) &&
        Objects.equals(this.exitCode, job.exitCode) &&
        Objects.equals(this.exitStatus, job.exitStatus) &&
        Objects.equals(this.cpuTime, job.cpuTime) &&
        Objects.equals(this.wallclockTime, job.wallclockTime) &&
        Objects.equals(this.ramMemory, job.ramMemory) &&
        Objects.equals(this.progressInfo, job.progressInfo) &&
        Objects.equals(this.statusHistory, job.statusHistory) &&
        Objects.equals(this.lastModifiedTime, job.lastModifiedTime) &&
        Objects.equals(this.monitoredFiles, job.monitoredFiles) &&
        Objects.equals(this.specificData, job.specificData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobId, groupId, sessionId, submitedBy, projectId, algorithmId, algorithmVersion, algorithmName,
      jobOwner, jobOwnerName, automaticallyMachineSelection, submissionMachine, submissionTime, executionMachine,
      endTime, numberOfAttempts, description, priority, state, exitCode, exitStatus, cpuTime, wallclockTime, ramMemory,
      progressInfo, statusHistory, lastModifiedTime, monitoredFiles, specificData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobInfo {\n");

    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    submitedBy: ").append(toIndentedString(submitedBy)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    algorithmId: ").append(toIndentedString(algorithmId)).append("\n");
    sb.append("    algorithmVersion: ").append(toIndentedString(algorithmVersion)).append("\n");
    sb.append("    algorithmName: ").append(toIndentedString(algorithmName)).append("\n");
    sb.append("    jobOwner: ").append(toIndentedString(jobOwner)).append("\n");
    sb.append("    jobOwnerName: ").append(toIndentedString(jobOwnerName)).append("\n");
    sb.append("    automaticallyMachineSelection: ").append(toIndentedString(automaticallyMachineSelection)).append(
      "\n");
    sb.append("    submissionMachine: ").append(toIndentedString(submissionMachine)).append("\n");
    sb.append("    submissionTime: ").append(toIndentedString(submissionTime)).append("\n");
    sb.append("    executionMachine: ").append(toIndentedString(executionMachine)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    numberOfAttempts: ").append(toIndentedString(numberOfAttempts)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    exitCode: ").append(toIndentedString(exitCode)).append("\n");
    sb.append("    exitStatus: ").append(toIndentedString(exitStatus)).append("\n");
    sb.append("    cpuTime: ").append(toIndentedString(cpuTime)).append("\n");
    sb.append("    wallclockTime: ").append(toIndentedString(wallclockTime)).append("\n");
    sb.append("    ramMemory: ").append(toIndentedString(ramMemory)).append("\n");
    sb.append("    progressInfo: ").append(toIndentedString(progressInfo)).append("\n");
    sb.append("    statusHistory: ").append(toIndentedString(statusHistory)).append("\n");
    sb.append("    lastModifiedTime: ").append(toIndentedString(lastModifiedTime)).append("\n");
    sb.append("    monitoredFiles: ").append(toIndentedString(monitoredFiles)).append("\n");
    sb.append("    specificData: ").append(toIndentedString(specificData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

