/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.blockingnio;

import csfs.impl.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public class BlockingNIOReceiverThread
extends Thread {
    private Socket socket;
    private String rootDir;
    public static final int HEADER_SIZE = 7;

    public BlockingNIOReceiverThread(Socket socket, String rootDir) {
        this.socket = socket;
        this.rootDir = rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel socketChannel = null;
        ByteBuffer response = ByteBuffer.allocate(1);
        try {
            socketChannel = this.socket.getChannel();
            try {
                int bytesRead;
                ByteBuffer headerSizeBuf = ByteBuffer.allocate(7);
                for (bytesRead = 0; bytesRead < 7; bytesRead += socketChannel.read(headerSizeBuf)) {
                }
                headerSizeBuf.rewind();
                int headerSize = (int)Util.readLongFromBuffer(headerSizeBuf);
                ByteBuffer headerBuf = ByteBuffer.allocate(headerSize);
                for (bytesRead = 0; bytesRead < headerSize; bytesRead += socketChannel.read(headerBuf)) {
                }
                headerBuf.rewind();
                long length = Util.readLongFromBuffer(headerBuf);
                String path = Util.readStringFromBuffer(headerBuf);
                this.writeDataToDisk(socketChannel, path, length);
                response.put(0, (byte)0);
            }
            catch (IOException e) {
                response.put(0, (byte)1);
            }
            finally {
                if (socketChannel != null) {
                    socketChannel.write(response);
                    socketChannel.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void writeDataToDisk(SocketChannel socketChannel, String path, long length) throws FileNotFoundException, IOException {
        while (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        path = Util.systemFileSeparatorToLocalFileSeparator(path);
        FileOutputStream file = new FileOutputStream(new File(this.rootDir, path));
        FileChannel fileChannel = file.getChannel();
        for (long transferred = 0L; transferred < length; transferred += fileChannel.transferFrom(socketChannel, transferred, length - transferred)) {
        }
        fileChannel.close();
    }
}

