/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeFileSystem {
    private static final String ENABLE_EXECUTION_PERMISSION_COMMAND = "chmod +x {0}";
    private static final String DISKSPACE_COMMAND = "df -m";
    private static final String DISKSPACE_REGEX = "(\\d+)\\s+(\\d+)\\s+(\\d+)";
    private static final int DISKSPACE_TOTAL_GROUP = 1;
    private static final int DISKSPACE_USED_GROUP = 2;
    private static final int DISKSPACE_FREE_GROUP = 3;

    public static long getSpace(String path, int group) {
        try {
            Process p = Runtime.getRuntime().exec("df -m " + path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = " ";
            String tmp = null;
            while ((tmp = reader.readLine()) != null) {
                line = line + tmp + " ";
            }
            reader.close();
            Pattern pattern = null;
            pattern = Pattern.compile(DISKSPACE_REGEX);
            Matcher matcher = pattern.matcher(line);
            matcher.find();
            String strMbytes = matcher.group(group);
            long mBytes = Long.parseLong(strMbytes);
            return mBytes;
        }
        catch (Exception e) {
            Logger.global.severe(e.getMessage());
            return -1L;
        }
    }

    public static long getFreeSpace(String path) {
        return NativeFileSystem.getSpace(path, 3);
    }

    public static long getTotalSpace(String path) {
        return NativeFileSystem.getSpace(path, 1);
    }

    public static final void enableExecutionPermission(String filePath) throws IOException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            String command = MessageFormat.format(ENABLE_EXECUTION_PERMISSION_COMMAND, filePath);
            Process p = Runtime.getRuntime().exec(command);
            int result = 0;
            try {
                result = p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (result != 0) {
                StringBuffer output = NativeFileSystem.getErrorMessage(p);
                Logger.global.severe("ERRO atribuindo permissao de execucao:" + output.toString());
            }
        }
    }

    private static StringBuffer getErrorMessage(Process p) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        StringBuffer output = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            output.append(line);
        }
        reader.close();
        return output;
    }
}

