/*
 * Decompiled with CFR 0.152.
 */
package csfs.remote;

import csfs.remote.FileAlreadyExistsException;
import csfs.remote.FileInUseException;
import csfs.remote.FileNotFoundException;
import csfs.remote.FileServer;
import csfs.remote.InvalidPathException;
import csfs.remote.InvalidStateException;
import csfs.remote.Metadata;
import csfs.remote.NotDirectoryException;
import csfs.remote.NotEmptyException;
import csfs.remote.NotFileException;
import csfs.remote.RandomAccessChannel;
import csfs.remote.ReadChannel;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import csfs.remote.WriteChannel;

public interface RemoteFileOperations {
    public RemoteFile createDirectory(String[] var1) throws NotDirectoryException, InvalidPathException, ServerException, FileAlreadyExistsException, InvalidStateException;

    public RemoteFile createFile(String[] var1) throws NotDirectoryException, InvalidPathException, ServerException, FileAlreadyExistsException, InvalidStateException;

    public boolean isDirectory() throws ServerException, InvalidStateException;

    public boolean tryLock() throws NotFileException, ServerException, InvalidStateException;

    public boolean unlock() throws NotFileException, ServerException, InvalidStateException;

    public boolean addMountPoint(String[] var1, RemoteFile var2) throws NotDirectoryException, InvalidPathException, ServerException, FileAlreadyExistsException, InvalidStateException;

    public RemoteFile removeMountPoint(String[] var1) throws FileNotFoundException, NotDirectoryException, InvalidPathException, ServerException, InvalidStateException;

    public String getName() throws ServerException, InvalidStateException;

    public String[] getFullName() throws ServerException, InvalidStateException;

    public boolean copyTo(RemoteFile var1, String var2) throws NotFileException, ServerException, InvalidStateException;

    public boolean moveTo(RemoteFile var1, String var2) throws NotFileException, FileInUseException, ServerException, InvalidStateException;

    public boolean truncate(long var1) throws NotFileException, FileInUseException, ServerException, InvalidStateException;

    public long lastModified() throws ServerException, InvalidStateException;

    public boolean remove() throws FileInUseException, ServerException, NotEmptyException, InvalidStateException;

    public RemoteFile getChild(String[] var1) throws FileNotFoundException, NotDirectoryException, InvalidPathException, ServerException, InvalidStateException;

    public RemoteFile[] getChildren() throws NotDirectoryException, ServerException, InvalidStateException;

    public RemoteFile getParent() throws InvalidPathException, ServerException, InvalidStateException;

    public long size() throws NotFileException, ServerException, InvalidStateException;

    public byte[] hash() throws NotFileException, ServerException, InvalidStateException;

    public FileServer getFileServer() throws ServerException;

    public ReadChannel getReadChannel() throws NotFileException, ServerException, InvalidStateException;

    public WriteChannel getWriteChannel() throws NotFileException, ServerException, InvalidStateException;

    public RandomAccessChannel getRandomAccessChannel() throws NotFileException, ServerException, InvalidStateException;

    public void setMetadata(Metadata[] var1) throws NotFileException, ServerException, InvalidStateException;

    public void updateMetadata(Metadata[] var1) throws NotFileException, ServerException, InvalidStateException;

    public Metadata[] getAllMetadata() throws NotFileException, ServerException, InvalidStateException;

    public Metadata[] getMetadata(String[] var1) throws NotFileException, ServerException, InvalidStateException;

    public void enableExecutionPermission() throws ServerException, InvalidStateException;
}

