/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.scp;

import csfs.datatransfer.DataTransferMethod;
import csfs.impl.util.SystemProperties;
import csfs.impl.util.Util;
import csfs.remote.FileServer;
import csfs.remote.InvalidStateException;
import csfs.remote.NotFileException;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class SCPMethod
implements DataTransferMethod {
    private static final String ROOT_DIR = "CANONICAL_ROOT_DIR";
    private static final String SCP_BINARY = "SCP_BINARY";
    private static final String USER = "USER";

    @Override
    public boolean copy(File localFile, RemoteFile destination, String method) throws NotFileException, InvalidStateException, IOException, ServerException {
        FileServer destinationServer = destination.getFileServer();
        String host = destinationServer.getCopyServerAddress(method);
        String targetFilename = Util.stringArrayToString(destination.getFullName());
        String targetPath = destinationServer.getProperty(ROOT_DIR);
        String target = Util.stringArrayToString(new String[]{targetPath, targetFilename});
        char remoteFileSeparator = destination.getFileServer().getFileSeparator().charAt(0);
        target = Util.remoteFileSeparatorToSystemFileSeparator(target, remoteFileSeparator);
        String scpBinaryPath = SystemProperties.getProperty(SCP_BINARY);
        scpBinaryPath = Util.localFileSeparatorToSystemFileSeparator(scpBinaryPath);
        String source = localFile.getAbsolutePath();
        source = Util.localFileSeparatorToSystemFileSeparator(source);
        String user = destinationServer.getProperty(USER);
        if (user == null) {
            user = "";
        } else if (!user.trim().equals("")) {
            user = user.trim() + "@";
        }
        String cmd = scpBinaryPath + " " + source + " " + user + host + ":" + target;
        Logger.global.info(">> cmd: " + cmd);
        Process p = Runtime.getRuntime().exec(cmd);
        int result = -1;
        try {
            result = p.waitFor();
        }
        catch (InterruptedException e) {
            return false;
        }
        return result == 0;
    }

    @Override
    public String getName() {
        return "SCPMethod";
    }

    @Override
    public String getDetailedInfo() {
        return "SCP Method (scp - Unix built-in)";
    }
}

