/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeSpec;

public class BooleanType
extends BaseType
implements SwitchTypeSpec {
    public BooleanType(int num) {
        super(num);
    }

    @Override
    public String typeName() {
        return "boolean";
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        return 8;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public void parse() {
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.BooleanHolder";
    }

    @Override
    public String printReadExpression(String strname) {
        return strname + ".read_boolean()";
    }

    @Override
    public String printWriteStatement(String var_name, String strname) {
        return strname + ".write_boolean(" + var_name + ");";
    }

    @Override
    public String printInsertExpression() {
        return "insert_boolean";
    }

    @Override
    public String printExtractExpression() {
        return "extract_boolean";
    }

    @Override
    public boolean isSwitchable() {
        return true;
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }
}

