/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.FloatPtType;
import org.jacorb.idl.TypeSpec;

public class FloatType
extends FloatPtType {
    public FloatType(int num) {
        super(num);
    }

    @Override
    public String typeName() {
        return "float";
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        return 6;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.FloatHolder";
    }

    @Override
    public String printReadExpression(String strname) {
        return strname + ".read_float()";
    }

    @Override
    public String printWriteStatement(String var_name, String strname) {
        return strname + ".write_float(" + var_name + ");";
    }

    @Override
    public String printInsertExpression() {
        return "insert_float";
    }

    @Override
    public String printExtractExpression() {
        return "extract_float";
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }
}

