/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.corba;

import csfs.datatransfer.DataTransferMethod;
import csfs.impl.util.SystemProperties;
import csfs.remote.ClosedChannelException;
import csfs.remote.InvalidStateException;
import csfs.remote.NotFileException;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import csfs.remote.WriteChannel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CORBAMethod
implements DataTransferMethod {
    @Override
    public boolean copy(File localFile, RemoteFile destination, String method) throws NotFileException, InvalidStateException, ServerException {
        boolean response = false;
        try {
            long read;
            int localRead;
            WriteChannel writer = destination.getWriteChannel();
            if (!localFile.isFile()) {
                throw new InvalidStateException("It is not possible to copy a directory", new String[0]);
            }
            int corbaBuffer = Integer.parseInt(method.substring(method.indexOf(45) + 1));
            byte[] buffer = new byte[corbaBuffer];
            long size = localFile.length();
            int bufferSize = SystemProperties.getIntProperty("BUFFERED_STREAM_SIZE_READER");
            InputStream reader = bufferSize > 0 ? new BufferedInputStream(new FileInputStream(localFile), bufferSize) : new FileInputStream(localFile);
            int bytesRead = 0;
            for (read = 0L; read < size && bytesRead != -1; read += (long)localRead) {
                localRead = 0;
                do {
                    if ((bytesRead = reader.read(buffer, localRead, buffer.length - localRead)) == -1) continue;
                    localRead += bytesRead;
                } while (bytesRead != -1 && localRead != buffer.length);
                writer.write(localRead, buffer);
            }
            reader.close();
            writer.close();
            if (read == size) {
                response = true;
            }
        }
        catch (ClosedChannelException ex) {
            ex.printStackTrace();
            throw new InvalidStateException("Destination channel was misteriously closed during copy operation:" + ex.getMessage(), destination.getFullName());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InvalidStateException("Problems reading from local file (" + localFile.getPath() + "):" + ex.getMessage(), new String[0]);
        }
        return response;
    }

    @Override
    public String getName() {
        return "CORBA";
    }

    @Override
    public String getDetailedInfo() {
        return "CORBA" + SystemProperties.getProperty("CORBA_BUFFER_SIZE");
    }
}

