/*
 * Decompiled with CFR 0.152.
 */
package csfs.client;

import csfs.client.RandomAccessWrapper;
import csfs.client.RandomAccessWrapperRegularFile;
import csfs.client.RandomAccessWrapperRemoteFile;
import csfs.remote.FileServer;
import csfs.remote.FileServerHelper;
import csfs.remote.InvalidPathException;
import csfs.remote.InvalidStateException;
import csfs.remote.NotDirectoryException;
import csfs.remote.NotFileException;
import csfs.remote.OctetSequenceHolder;
import csfs.remote.RandomAccessChannel;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class RandomAccessTest {
    public static final int BLOCK_SIZE = 524288;
    public static final long RANDOM_SEED = 1L;
    public static final long BYTES_TO_TRANSFER = 0x40000000L;

    public static void main(String[] args) throws Exception {
        byte[] buffer = new byte[524288];
        Random random = new Random(1L);
        RandomAccessWrapper raf = RandomAccessTest.createWrapperFile(buffer);
        long fileSize = raf.length();
        long steps = 2048L;
        long total = 0L;
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < steps) {
            int read;
            long seek = Math.abs(random.nextLong()) % fileSize;
            if ((seek -= 524288L) < 0L) {
                seek = 0L;
            }
            raf.seek(seek);
            for (read = 0; read < 524288; read += raf.read(read, 524288 - read)) {
            }
            total += (long)read;
            if (i % 100 == 0) {
                System.out.println("SEEK: " + seek + " READ: " + total + " bytes in " + (System.currentTimeMillis() - start) + " ms");
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("FINISHED!!! BLOCK_SIZE = 524288 READ: " + total + " bytes in " + (end - start) + " ms");
    }

    private static RandomAccessWrapper createWrapperFile(byte[] buffer) throws FileNotFoundException {
        String pathToNFSFile = "H:\\csfs\\teste.bin";
        RandomAccessFile rafNFS = new RandomAccessFile(pathToNFSFile, "rw");
        RandomAccessWrapperRegularFile raf = new RandomAccessWrapperRegularFile(rafNFS, buffer);
        return raf;
    }

    private static RandomAccessWrapper createWrapperCORBA(String[] args, byte[] buffer) throws FileNotFoundException, IOException, csfs.remote.FileNotFoundException, NotDirectoryException, InvalidPathException, ServerException, InvalidStateException, NotFileException {
        ORB orb = ORB.init((String[])args, null);
        BufferedReader br = new BufferedReader(new FileReader(args[0]));
        Object obj = orb.string_to_object(br.readLine());
        br.close();
        FileServer fileServer = FileServerHelper.narrow(obj);
        RemoteFile source = fileServer.getRoot().getChild(new String[]{"teste.bin"});
        RandomAccessChannel rafRemote = source.getRandomAccessChannel();
        OctetSequenceHolder holder = new OctetSequenceHolder(buffer);
        RandomAccessWrapperRemoteFile raf = new RandomAccessWrapperRemoteFile(rafRemote, holder);
        return raf;
    }
}

