/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Member;
import org.jacorb.idl.MemberList;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class StructType
extends TypeDeclaration
implements Scope {
    private boolean written = false;
    public boolean exc;
    public MemberList memberlist = null;
    private boolean parsed = false;
    private ScopeData scopeData;
    private boolean forwardDecl;
    private static final HashSet<String> systemExceptionNames = new HashSet();

    public StructType(int num) {
        super(num);
        this.pack_name = "";
    }

    @Override
    public void setScopeData(ScopeData data) {
        this.scopeData = data;
    }

    @Override
    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public boolean isException() {
        return this.exc;
    }

    @Override
    public Object clone() {
        StructType st = new StructType(StructType.new_num());
        st.pack_name = this.pack_name;
        st.name = this.name;
        st.memberlist = this.memberlist;
        st.included = this.included;
        st.token = this.token;
        st.exc = this.exc;
        st.scopeData = this.scopeData;
        st.enclosing_symbol = this.enclosing_symbol;
        return st;
    }

    @Override
    public TypeDeclaration declaration() {
        return this;
    }

    @Override
    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public int getTCKind() {
        return 15;
    }

    @Override
    public boolean basic() {
        return false;
    }

    public void set_memberlist(MemberList m) {
        m.setContainingType(this);
        this.memberlist = m;
        this.memberlist.setPackage(this.name);
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.memberlist != null) {
            this.memberlist.setPackage(s);
        }
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            parser.logger.log(Level.SEVERE, "was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public void parse() {
        boolean justAnotherOne = false;
        if (this.parsed) {
            return;
        }
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "Parsing Struct " + this.name);
        }
        this.escapeName();
        ConstrTypeSpec ctspec = new ConstrTypeSpec(StructType.new_num());
        try {
            ScopedName.definePseudoScope(this.full_name());
            ctspec.c_type_spec = this;
            NameTable.define(this.full_name(), IDLTypes.TYPE_STRUCT);
            TypeMap.typedef(this.full_name(), ctspec);
        }
        catch (NameAlreadyDefined nad) {
            if (this.exc) {
                parser.error("Struct " + this.typeName() + " already defined", this.token);
            }
            Object forwardDeclaration = parser.get_pending(this.full_name());
            if (forwardDeclaration != null) {
                if (!(forwardDeclaration instanceof StructType)) {
                    parser.error("Forward declaration types mismatch for " + this.full_name() + ": name already defined with another type", this.token);
                }
                if (this.memberlist != null) {
                    justAnotherOne = true;
                }
                if (!this.full_name().equals("org.omg.CORBA.TypeCode") && this.memberlist != null) {
                    TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
                }
            }
            parser.error("Struct " + this.typeName() + " already defined", this.token);
        }
        if (this.memberlist != null) {
            ScopedName.addRecursionScope(this.typeName());
            this.memberlist.parse();
            ScopedName.removeRecursionScope(this.typeName());
            if (!this.exc) {
                NameTable.parsed_interfaces.put(this.full_name(), "");
                parser.remove_pending(this.full_name());
            }
        } else if (!justAnotherOne && !this.exc) {
            parser.set_pending(this.full_name(), this);
            this.forwardDecl = true;
        }
        this.parsed = true;
    }

    public String className() {
        String fullName = this.typeName();
        if (fullName.indexOf(46) > 0) {
            return fullName.substring(fullName.lastIndexOf(46) + 1);
        }
        return fullName;
    }

    @Override
    public String printReadExpression(String Streamname) {
        return this.toString() + "Helper.read(" + Streamname + ")";
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        return this.toString() + "Helper.write(" + streamname + "," + var_name + ");";
    }

    @Override
    public String holderName() {
        return this.typeName() + "Holder";
    }

    @Override
    public String helperName() {
        return this.typeName() + "Helper";
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        knownTypes.add(this);
        StringBuffer sb = new StringBuffer();
        sb.append("org.omg.CORBA.ORB.init().create_" + (this.exc ? "exception" : "struct") + "_tc(" + this.typeName() + "Helper.id(),\"" + this.className() + "\",");
        if (this.memberlist != null) {
            sb.append("new org.omg.CORBA.StructMember[]{");
            Enumeration e = this.memberlist.v.elements();
            while (e.hasMoreElements()) {
                HashSet knownTypesLocal = new HashSet(knownTypes);
                Member m = (Member)e.nextElement();
                Declarator d = m.declarator;
                sb.append("new org.omg.CORBA.StructMember(\"" + d.name() + "\", ");
                sb.append(m.type_spec.typeSpec().getTypeCodeExpression(knownTypesLocal));
                sb.append(", null)");
                if (!e.hasMoreElements()) continue;
                sb.append(",");
            }
            sb.append("}");
        } else {
            sb.append("new org.omg.CORBA.StructMember[0]");
        }
        sb.append(")");
        return sb.toString();
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment(this.exc ? "exception" : "struct", className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + this.typeName() + " value;" + Environment.NL);
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder(final " + this.typeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.typeName() + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read(final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + this.typeName() + "Helper.read(_in);");
        ps.println("\t}");
        ps.println("\tpublic void _write(final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + this.typeName() + "Helper.write(_out, value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        Declarator d;
        Member m;
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";" + Environment.NL);
        }
        this.printImport(ps);
        this.printClassComment(this.exc ? "exception" : "struct", className, ps);
        ps.println("public abstract class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate volatile static org.omg.CORBA.TypeCode _type;");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        ps.println("\t{");
        ps.println("\t\tif (_type == null)");
        ps.println("\t\t{");
        ps.println("\t\t\tsynchronized(" + this.name + "Helper.class)");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tif (_type == null)");
        ps.println("\t\t\t\t{");
        ps.println("\t\t\t\t\t_type = " + this.getTypeCodeExpression() + ";");
        ps.println("\t\t\t\t}");
        ps.println("\t\t\t}");
        ps.println("\t\t}");
        ps.println("\t\treturn _type;");
        ps.println("\t}" + Environment.NL);
        String type = this.typeName();
        TypeSpec.printInsertExtractMethods(ps, type);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        if (parser.hasObjectCachePlugin()) {
            ps.println("\t\t// ObjectCachePlugin BEGIN");
            parser.getObjectCachePlugin().printCheckout(ps, type, "result");
            parser.getObjectCachePlugin().printPreMemberRead(ps, this);
            ps.println("\t\t// ObjectCachePlugin END");
        }
        if (this.exc) {
            Enumeration e;
            int x;
            ps.println("\t\tString id = in.read_string();");
            ps.println("\t\tif (!id.equals(id())) throw new org.omg.CORBA.MARSHAL(\"wrong id: \" + id);");
            if (parser.generatedHelperPortability == 2) {
                ps.println("\t\tif (in instanceof org.jacorb.orb.giop.ReplyInputStream)");
                ps.println("\t\t{");
                ps.println("\t\t\torg.jacorb.orb.giop.ReplyInputStream reply = (org.jacorb.orb.giop.ReplyInputStream) in;");
                ps.println("\t\t\torg.omg.IOP.ServiceContext context = null;");
                ps.println("\t\t\tif ( (context = reply.getServiceContext(org.omg.IOP.ExceptionDetailMessage.value)) != null)");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\torg.jacorb.orb.CDRInputStream details = new org.jacorb.orb.CDRInputStream(context.context_data);");
                ps.println("\t\t\t\tdetails.openEncapsulatedArray();");
                ps.println("\t\t\t\tid = details.read_wstring();");
                ps.println("\t\t\t}");
                ps.println("\t\t}");
            }
            if (!parser.hasObjectCachePlugin() && this.memberlist != null) {
                x = 0;
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    Member member = (Member)e.nextElement();
                    TypeSpec typeSpec = member.type_spec.typeSpec();
                    String var = "x" + x++;
                    ps.println("\t\t" + typeSpec.typeName() + " " + var + ";");
                    ps.println("\t\t" + typeSpec.printReadStatement(var, "in"));
                }
            }
            if (parser.hasObjectCachePlugin()) {
                if (this.memberlist != null) {
                    Enumeration e2 = this.memberlist.v.elements();
                    while (e2.hasMoreElements()) {
                        m = (Member)e2.nextElement();
                        d = m.declarator;
                        ps.println("\t\t" + m.type_spec.typeSpec().printReadStatement("result." + d.name(), "in"));
                    }
                }
            } else {
                ps.print("\t\tfinal " + type + " result = new " + type + "(");
                ps.print("id");
                if (this.memberlist != null) {
                    x = 0;
                    e = this.memberlist.v.elements();
                    while (e.hasMoreElements()) {
                        ps.print(", x" + x++);
                        e.nextElement();
                    }
                }
                ps.println(");");
            }
        } else {
            if (!parser.hasObjectCachePlugin()) {
                ps.println("\t\t" + type + " result = new " + type + "();");
            }
            if (this.memberlist != null) {
                Enumeration e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    m = (Member)e.nextElement();
                    d = m.declarator;
                    ps.println("\t\t" + m.type_spec.typeSpec().printReadStatement("result." + d.name(), "in"));
                }
            }
        }
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printPostMemberRead(ps, this, "result");
        }
        ps.println("\t\treturn result;");
        ps.println("\t}");
        if (parser.hasObjectCachePlugin()) {
            parser.getObjectCachePlugin().printCheckinHelper(ps, this);
        }
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        ps.println("\t{");
        if (this.exc) {
            ps.println("\t\tout.write_string(id());");
        }
        if (this.memberlist != null) {
            Enumeration e = this.memberlist.v.elements();
            while (e.hasMoreElements()) {
                m = (Member)e.nextElement();
                d = m.declarator;
                ps.println("\t\t" + m.type_spec.typeSpec().printWriteStatement("s." + d.name(), "out"));
            }
        }
        ps.println("\t}");
        ps.println("}");
    }

    private void printStructClass(String className, PrintWriter ps) {
        String fullClassName = className;
        if (!this.pack_name.equals("")) {
            fullClassName = this.pack_name + "." + className;
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment(this.exc ? "exception" : "struct", className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className);
        if (this.exc) {
            if (this.isSystemException(className)) {
                ps.println("\textends org.omg.CORBA.SystemException");
            } else {
                ps.println("\textends org.omg.CORBA.UserException");
            }
        } else {
            ps.println("\timplements org.omg.CORBA.portable.IDLEntity");
        }
        ps.println("{");
        this.printSerialVersionUID(ps);
        if (this.exc) {
            if (this.isSystemException(className)) {
                ps.println("\tpublic " + className + "()");
                ps.println("\t{");
                ps.print("\t\tsuper(");
                ps.print(" \"\"");
                ps.print(", 0");
                ps.print(" ,org.omg.CORBA.CompletionStatus.COMPLETED_NO");
                ps.println(" ) ;");
                ps.println("\t}");
                ps.println();
                ps.println("\tpublic " + className + "( String reason )");
                ps.println("\t{");
                ps.print("\t\tsuper(");
                ps.print(" reason");
                ps.print(", 0");
                ps.print(" ,org.omg.CORBA.CompletionStatus.COMPLETED_NO");
                ps.println(" ) ;");
                ps.println("\t}");
                ps.println();
                ps.print("\tpublic " + className + "(");
                ps.print("int minor");
                ps.print(", org.omg.CORBA.CompletionStatus completed");
                ps.println(" )");
                ps.println("\t{");
                ps.print("\t\tsuper(");
                ps.print(" \"\"");
                ps.print(", minor");
                ps.print(", completed");
                ps.println(" ) ;");
                ps.println("\t}");
                ps.println();
                ps.print("\tpublic " + className + "(");
                ps.print("String reason");
                ps.print(", int minor");
                ps.print(", org.omg.CORBA.CompletionStatus completed");
                ps.println(" )");
                ps.println("\t{");
                ps.print("\t\tsuper(");
                ps.print(" reason");
                ps.print(", minor");
                ps.print(", completed");
                ps.println(" ) ;");
                ps.println("\t}");
                ps.println();
            } else {
                ps.println("\tpublic " + className + "()");
                ps.println("\t{");
                ps.println("\t\tsuper(" + fullClassName + "Helper.id());");
                ps.println("\t}");
                ps.println();
                if (this.memberlist == null) {
                    ps.println("\tpublic " + className + "(String value)");
                    ps.println("\t{");
                    ps.println("\t\tsuper(value);");
                    ps.println("\t}");
                }
            }
        } else {
            ps.println("\tpublic " + className + "(){}");
        }
        if (this.memberlist != null) {
            Declarator d;
            Member m;
            Enumeration e;
            if (!this.isSystemException(className)) {
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    ((Member)e.nextElement()).member_print(ps, "\tpublic ");
                    ps.println();
                }
            }
            if (parser.generateEnhanced) {
                this.printToString(fullClassName, ps);
                this.printEquals(fullClassName, ps);
            }
            if (this.exc && !this.isSystemException(className)) {
                ps.print("\tpublic " + className + "(");
                ps.print("java.lang.String _reason,");
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    m = (Member)e.nextElement();
                    d = m.declarator;
                    ps.print(m.type_spec.toString() + " " + d.toString());
                    if (!e.hasMoreElements()) continue;
                    ps.print(", ");
                }
                ps.println(")");
                ps.println("\t{");
                ps.println("\t\tsuper(_reason);");
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    m = (Member)e.nextElement();
                    d = m.declarator;
                    ps.print("\t\tthis.");
                    ps.print(d.name());
                    ps.print(" = ");
                    ps.println(d.name() + ";");
                }
                ps.println("\t}");
            }
            if (!this.isSystemException(className)) {
                ps.print("\tpublic " + className + "(");
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    m = (Member)e.nextElement();
                    d = m.declarator;
                    ps.print(m.type_spec.toString() + " " + d.name());
                    if (!e.hasMoreElements()) continue;
                    ps.print(", ");
                }
                ps.println(")");
                ps.println("\t{");
                if (this.exc) {
                    ps.println("\t\tsuper(" + fullClassName + "Helper.id());");
                }
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    m = (Member)e.nextElement();
                    d = m.declarator;
                    ps.print("\t\tthis.");
                    ps.print(d.name());
                    ps.print(" = ");
                    ps.println(d.name() + ";");
                }
                ps.println("\t}");
            }
        }
        ps.println("}");
    }

    @Override
    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (!this.parsed) {
            lexer.restorePosition(this.myPosition);
            parser.fatal_error("Unparsed Struct!", this.token);
        }
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written) {
            this.written = true;
            try {
                PrintWriter printWriter;
                String className = this.className();
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                String fname = className + ".java";
                File f = new File(dir, fname);
                if (!this.forwardDecl && GlobalInputStream.isMoreRecentThan(f)) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printStructClass(className, printWriter);
                    printWriter.close();
                }
                fname = className + "Holder.java";
                f = new File(dir, fname);
                if (!this.forwardDecl && GlobalInputStream.isMoreRecentThan(f) && !this.isSystemException(className)) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, printWriter);
                    printWriter.close();
                }
                fname = className + "Helper.java";
                f = new File(dir, fname);
                if (!this.forwardDecl && GlobalInputStream.isMoreRecentThan(f)) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, printWriter);
                    printWriter.close();
                }
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + this.pack_name + "." + this.className() + "Helper.insert(" + anyname + ", " + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + this.pack_name + "." + this.className() + "Helper.extract(" + anyname + ");");
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitStruct(this);
    }

    private void printEquals(String s, PrintWriter printwriter) {
        printwriter.println("\tpublic boolean equals(java.lang.Object o) ");
        printwriter.println("\t{ ");
        StringBuffer buffer = new StringBuffer("\t\tif (this == o) return true;");
        buffer.append(Environment.NL);
        buffer.append("\t\tif (o == null) return false;");
        buffer.append(Environment.NL);
        buffer.append(Environment.NL);
        buffer.append("\t\tif (o instanceof " + s + " )" + Environment.NL + "\t\t{");
        buffer.append(Environment.NL);
        buffer.append("\t\t\tfinal " + s + " obj = ( " + s + " )o;");
        buffer.append(Environment.NL);
        buffer.append("\t\t\tboolean res = true; ");
        buffer.append(Environment.NL);
        buffer.append("\t\t\tdo { ");
        buffer.append(Environment.NL);
        Enumeration enumeration = this.memberlist.v.elements();
        while (enumeration.hasMoreElements()) {
            Member member = (Member)enumeration.nextElement();
            if (BaseType.isBasicName(member.type_spec.toString()) && !member.type_spec.toString().equals("String") && !member.type_spec.toString().equals("java.lang.String") && member.type_spec.toString().indexOf("[") < 0) {
                buffer.append("\t\t\t\tres = (this." + member.declarator.toString() + " == obj." + member.declarator.toString() + ");");
                buffer.append(Environment.NL);
                buffer.append("\t\t\t\tif (!res) break;" + Environment.NL + Environment.NL);
                continue;
            }
            if (member.type_spec.toString().indexOf("[") >= 0) {
                buffer.append("\t\t\t\tres = (this." + member.declarator.toString() + " == obj." + member.declarator.toString() + ") || (this." + member.declarator.toString() + " != null && obj." + member.declarator.toString() + " != null && this." + member.declarator.toString() + ".length == obj." + member.declarator.toString() + ".length);" + Environment.NL);
                buffer.append("\t\t\t\tif (res)" + Environment.NL + Environment.NL + "\t\t\t\t{" + Environment.NL);
                buffer.append("\t\t\t\t\tres = java.util.Arrays.equals(this." + member.declarator.toString() + ", obj." + member.declarator.toString() + ");" + Environment.NL);
                buffer.append("\t\t\t\t}" + Environment.NL);
                buffer.append("\t\t\t\tif(!res) break;" + Environment.NL + Environment.NL);
                continue;
            }
            buffer.append("\t\t\t\tres = (this." + member.declarator.toString() + " == obj." + member.declarator.toString() + ") || (this." + member.declarator.toString() + " != null && obj." + member.declarator.toString() + " != null && this." + member.declarator.toString() + ".equals (obj." + member.declarator.toString() + "));" + Environment.NL);
            buffer.append("\t\t\t\tif (!res) break;" + Environment.NL + Environment.NL);
        }
        buffer.append("\t\t\t}");
        buffer.append(Environment.NL);
        buffer.append("\t\t\twhile(false);");
        buffer.append(Environment.NL);
        buffer.append("\t\t\treturn res;");
        buffer.append(Environment.NL);
        buffer.append("\t\t}");
        buffer.append(Environment.NL);
        buffer.append("\t\telse" + Environment.NL + "\t\t{" + Environment.NL);
        buffer.append("\t\t\treturn false;");
        buffer.append(Environment.NL);
        buffer.append("\t\t}");
        buffer.append(Environment.NL);
        buffer.append("\t}");
        buffer.append(Environment.NL);
        printwriter.println(buffer.toString());
        printwriter.println();
    }

    private void printToString(String s, PrintWriter printwriter) {
        printwriter.println("\tpublic String toString() ");
        printwriter.println("\t{ ");
        StringBuffer buffer = new StringBuffer("\t\tfinal java.lang.StringBuffer _ret  =  new java.lang.StringBuffer(\"struct " + s + " {\"); ");
        buffer.append(Environment.NL);
        buffer.append("\t\t_ret.append(\"\\n\"); ");
        Enumeration enumeration = this.memberlist.v.elements();
        while (enumeration.hasMoreElements()) {
            Member member = (Member)enumeration.nextElement();
            buffer.append(Environment.NL);
            buffer.append("\t\t_ret.append(\"" + member.type_spec.toString() + " " + member.declarator.toString() + "=\");");
            buffer.append(Environment.NL);
            if (member.type_spec.toString().indexOf("[") < 0) {
                buffer.append("\t\t_ret.append(" + member.declarator.toString() + ");");
            } else {
                buffer.append("\t\t_ret.append(\"{\");");
                buffer.append(Environment.NL);
                buffer.append("\t\tif(" + member.declarator.toString() + "== null){");
                buffer.append(Environment.NL);
                buffer.append("\t\t\t_ret.append(" + member.declarator.toString() + ");");
                buffer.append(Environment.NL);
                buffer.append("\t\t}else { ");
                buffer.append(Environment.NL);
                buffer.append("\t\t\tfor(int $counter =0; $counter < " + member.declarator.toString() + ".length; $counter++){ ");
                buffer.append(Environment.NL);
                buffer.append("\t\t\t\t_ret.append(" + member.declarator + "[$counter]);");
                buffer.append(Environment.NL);
                buffer.append("\t\t\t\tif($counter < " + member.declarator.toString() + ".length-1) { ");
                buffer.append(Environment.NL);
                buffer.append("\t\t\t\t\t_ret.append(\",\");");
                buffer.append(Environment.NL);
                buffer.append("\t\t\t\t} ");
                buffer.append(Environment.NL);
                buffer.append("\t\t\t}");
                buffer.append(Environment.NL);
                buffer.append("\t\t} ");
                buffer.append(Environment.NL);
                buffer.append("\t\t_ret.append(\"}\");");
                buffer.append(Environment.NL);
            }
            buffer.append(Environment.NL);
            if (enumeration.hasMoreElements()) {
                buffer.append("\t\t_ret.append(\",\\n\");");
                continue;
            }
            buffer.append("\t\t_ret.append(\"\\n\");");
        }
        buffer.append(Environment.NL);
        buffer.append("\t\t_ret.append(\"}\");" + Environment.NL);
        buffer.append("\t\treturn _ret.toString();");
        printwriter.println(buffer);
        printwriter.println("\t} ");
        printwriter.println();
    }

    private boolean isSystemException(String className) {
        String ucClassName = className.toUpperCase();
        return systemExceptionNames.contains(ucClassName);
    }

    static {
        systemExceptionNames.add("UNKNOWN");
        systemExceptionNames.add("BAD_PARAM");
        systemExceptionNames.add("NO_MEMORY");
        systemExceptionNames.add("IMP_LIMIT");
        systemExceptionNames.add("COMM_FAILURE");
        systemExceptionNames.add("INV_OBJREF");
        systemExceptionNames.add("NO_PERMISSION");
        systemExceptionNames.add("INTERNAL");
        systemExceptionNames.add("MARSHAL");
        systemExceptionNames.add("INITIALIZE");
        systemExceptionNames.add("NO_IMPLEMENT");
        systemExceptionNames.add("BAD_TYPECODE");
        systemExceptionNames.add("BAD_OPERATION");
        systemExceptionNames.add("NO_RESOURCES");
        systemExceptionNames.add("NO_RESPONSE");
        systemExceptionNames.add("PERSIST_STORE");
        systemExceptionNames.add("BAD_INV_ORDER");
        systemExceptionNames.add("TRANSIENT");
        systemExceptionNames.add("FREE_MEM");
        systemExceptionNames.add("INV_IDENT");
        systemExceptionNames.add("INV_FLAG");
        systemExceptionNames.add("INTF_REPOS");
        systemExceptionNames.add("BAD_CONTEXT");
        systemExceptionNames.add("OBJ_ADAPTER");
        systemExceptionNames.add("DATA_CONVERSION");
        systemExceptionNames.add("OBJECT_NOT_EXIST");
        systemExceptionNames.add("TRANSACTION_REQUIRED");
        systemExceptionNames.add("TRANSACTION_ROLLEDBACK");
        systemExceptionNames.add("INVALID_TRANSACTION");
        systemExceptionNames.add("INV_POLICY");
        systemExceptionNames.add("CODESET_INCOMPATIBLE");
        systemExceptionNames.add("REBIND");
        systemExceptionNames.add("TIMEOUT");
        systemExceptionNames.add("TRANSACTION_UNAVAILABLE");
        systemExceptionNames.add("TRANSACTION_MODE");
        systemExceptionNames.add("BAD_QOS");
        systemExceptionNames.add("INVALID_ACTIVITY");
        systemExceptionNames.add("ACTIVITY_COMPLETED");
        systemExceptionNames.add("ACTIVITY_REQUIRED");
    }
}

