/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import org.jacorb.naming.Name;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class ContextLister {
    public NamingContext root_context;
    private HashSet<String> contexts = new HashSet();
    private ORB orb;

    public ContextLister(ORB orb) {
        this.orb = orb;
        try {
            Object obj = orb.resolve_initial_references("NameService");
            this.root_context = NamingContextHelper.narrow((Object)obj);
        }
        catch (InvalidName inex) {
            inex.printStackTrace();
        }
        catch (SystemException corba_exception) {
            System.err.println((java.lang.Object)corba_exception);
        }
        if (this.root_context == null) {
            System.err.println("No Naming Context available, giving up ...");
            System.exit(1);
        }
    }

    public ContextLister(ORB orb, String str) {
        this.orb = orb;
        try {
            Object obj = orb.string_to_object(str);
            this.root_context = NamingContextHelper.narrow((Object)obj);
        }
        catch (SystemException corba_exception) {
            System.err.println((java.lang.Object)corba_exception);
        }
        if (this.root_context == null) {
            System.err.println("No Naming Context available, giving up ...");
            System.exit(1);
        }
    }

    private void mark(NamingContext nc) {
        this.contexts.add(this.orb.object_to_string((Object)nc));
    }

    private boolean isMarked(NamingContext nc) {
        return this.contexts.contains(this.orb.object_to_string((Object)nc));
    }

    public void list(PrintStream ps) {
        this.list(this.root_context, "   ", ps);
    }

    private void list(NamingContext n, String indent, PrintStream ps) {
        if (this.isMarked(n)) {
            System.out.println("Loop detected for " + n);
            return;
        }
        this.mark(n);
        try {
            BindingListHolder blsoh = new BindingListHolder(new Binding[0]);
            BindingIteratorHolder bioh = new BindingIteratorHolder();
            n.list(0, blsoh, bioh);
            BindingHolder bh = new BindingHolder();
            if (bioh.value == null) {
                return;
            }
            while (bioh.value.next_one(bh)) {
                String stringName = Name.toString(bh.value.binding_name);
                ps.print(indent + stringName);
                if (bh.value.binding_type.value() == 1) {
                    String _indent = indent + "\t";
                    ps.println("/");
                    NameComponent[] name = Name.toName(stringName);
                    NamingContext sub_context = NamingContextHelper.narrow((Object)n.resolve(name));
                    this.list(sub_context, _indent, ps);
                    continue;
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ORB orb = ORB.init((String[])args, null);
        PrintStream pw = System.out;
        String url = null;
        for (int i = 0; i < args.length; i += 2) {
            try {
                if (args[i].startsWith("-f")) {
                    try {
                        pw = new PrintStream(new FileOutputStream(args[i + 1]));
                    }
                    catch (IOException ioe) {
                        System.err.println(ioe.getMessage());
                        System.exit(1);
                    }
                    continue;
                }
                if (!args[i].startsWith("-url")) continue;
                url = args[i + 1];
                continue;
            }
            catch (Exception e) {
                System.err.println("Usage: org.jacorb.naming.ContextLister [-url object url] [-f output file]");
                System.exit(1);
            }
        }
        ContextLister ctxLister = url != null ? new ContextLister(orb, url) : new ContextLister(orb);
        ctxLister.list(pw);
        orb.shutdown(true);
    }
}

