/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Set;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class StringType
extends TemplateTypeSpec {
    private static int tmpResultsCount = 0;
    public ConstExpr max = null;
    private boolean wide = false;

    public StringType(int num) {
        super(num);
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide() {
        this.wide = true;
    }

    @Override
    public Object clone() {
        StringType s = new StringType(StringType.new_num());
        s.max = this.max;
        if (this.wide) {
            s.setWide();
        }
        s.parse();
        return s;
    }

    @Override
    public String typeName() {
        return "java.lang.String";
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public int getTCKind() {
        return 18;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public void print(PrintWriter pw) {
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        if (this.max != null) {
            this.max.setPackage(s);
        }
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.StringHolder";
    }

    @Override
    public String getTypeCodeExpression() {
        if (this.wide) {
            return "org.omg.CORBA.ORB.init().create_wstring_tc(" + (this.max == null ? 0 : this.max.pos_int_const()) + ')';
        }
        return "org.omg.CORBA.ORB.init().create_string_tc(" + (this.max == null ? 0 : this.max.pos_int_const()) + ')';
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        return this.getTypeCodeExpression();
    }

    @Override
    public String printReadExpression(String strname) {
        if (this.wide) {
            return strname + ".read_wstring()";
        }
        return strname + ".read_string()";
    }

    @Override
    public String printReadStatement(String var_name, String strname) {
        String readExpr = this.wide ? var_name + "=" + strname + ".read_wstring()" : var_name + "=" + strname + ".read_string()";
        if (this.max != null) {
            String varName = this.getFullName(ScopedName.unPseudoName(this.pack_name.length() > 0 ? this.pack_name + "." + this.name : this.name));
            readExpr = "if( (" + readExpr + ").length() > " + this.max.pos_int_const() + " ) throw new org.omg.CORBA.BAD_PARAM(\"String bounds violation for " + varName + ": only not greater than <" + this.max.pos_int_const() + "> length is allowed\")";
        }
        readExpr = readExpr + ";";
        return readExpr;
    }

    @Override
    public String printWriteStatement(String var_name, String strname) {
        String tmpResultName = "tmpResult" + tmpResultsCount++;
        String writeStat = "java.lang.String " + tmpResultName + " = " + var_name + ';' + Environment.NL;
        String writeExpr = this.wide ? strname + ".write_wstring( " + tmpResultName + " )" : strname + ".write_string( " + tmpResultName + " )";
        writeStat = this.max != null ? writeStat + "if( " + tmpResultName + ".length() > " + this.max.pos_int_const() + " ) { throw new org.omg.CORBA.BAD_PARAM( \"String bounds violation for " + var_name + ": only not greater than <" + this.max.pos_int_const() + "> length is allowed\"); } else { " + writeExpr + "; }" : writeStat + writeExpr + ";";
        return writeStat;
    }

    @Override
    public String printInsertExpression() {
        if (this.wide) {
            return "insert_wstring";
        }
        return "insert_string";
    }

    @Override
    public String printExtractExpression() {
        if (this.wide) {
            return "extract_wstring";
        }
        return "extract_string";
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }

    public void setSize(ConstExpr max_) {
        this.max = max_;
    }

    public ConstExpr getSize() {
        return this.max;
    }
}

