/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.filetracker;

import java.io.Closeable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTracker {
    private static FileTracker instance;
    private Hashtable fileUsage = new Hashtable();
    private Hashtable channelFileDescriptor = new Hashtable();

    protected FileTracker() {
    }

    public static FileTracker getInstance() {
        if (instance == null) {
            instance = new FileTracker();
            System.out.println("Why don't you use the FileTrackerLeasing?!");
        }
        return instance;
    }

    public void setFileDescriptor(String key, Object fileDescriptor) {
        if (fileDescriptor instanceof Closeable) {
            String file = key.substring(0, key.lastIndexOf(95));
            this.incUsersCount(file);
            this.channelFileDescriptor.put(key, fileDescriptor);
        }
    }

    public Object getFileDescriptor(String key) {
        return this.channelFileDescriptor.get(key);
    }

    public void removeFileDescriptor(String key) {
        if (this.channelFileDescriptor.containsKey(key)) {
            String file = key.substring(0, key.lastIndexOf(95));
            this.decUsersCount(file);
            this.closeFileDescriptor(key);
            this.channelFileDescriptor.remove(key);
        }
    }

    public boolean inUse(String key) {
        Object count = this.fileUsage.get(key);
        return count != null;
    }

    private void closeFileDescriptor(String key) {
        try {
            Closeable fd = (Closeable)this.getFileDescriptor(key);
            fd.close();
        }
        catch (IOException ex) {
            Logger.global.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void incUsersCount(String key) {
        Integer count = (Integer)this.fileUsage.get(key);
        count = count == null ? new Integer(1) : new Integer(count + 1);
        this.fileUsage.put(key, count);
    }

    private void decUsersCount(String key) {
        Integer count = (Integer)this.fileUsage.get(key);
        if (count == 1) {
            this.fileUsage.remove(key);
        } else {
            this.fileUsage.put(key, new Integer(count - 1));
        }
    }

    public int totalOpenFileDescriptors() {
        return this.channelFileDescriptor.size();
    }
}

