/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.metadata;

import csfs.remote.Metadata;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MetadataManager {
    private static final String METADATA_FILE_SUFFIX = ".csfs_metadata";

    public void saveMetadataInfo(Metadata[] metadata, File localFile) throws IOException {
        File dir = localFile.getParentFile();
        File metadataFile = new File(dir, localFile.getName() + METADATA_FILE_SUFFIX);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(metadataFile)));
        out.writeObject(metadata);
        out.close();
    }

    public void updateMetadata(Metadata[] metadata, File localFile) throws IOException {
        Metadata[] old = this.getMetadata(localFile);
        boolean[] updated = new boolean[metadata.length];
        int updateCount = 0;
        for (int i = 0; i < old.length; ++i) {
            for (int j = 0; j < metadata.length; ++j) {
                if (!old[i].field.equals(metadata[j].field)) continue;
                old[i].value = metadata[j].value;
                updated[j] = true;
                ++updateCount;
            }
        }
        Metadata[] result = new Metadata[old.length + metadata.length - updateCount];
        int k = 0;
        for (int i = 0; i < old.length + metadata.length; ++i) {
            if (i < old.length) {
                result[k] = old[i];
                ++k;
                continue;
            }
            if (updated[i - old.length]) continue;
            result[k] = metadata[i - old.length];
            ++k;
        }
        this.saveMetadataInfo(result, localFile);
    }

    public void lookupMetadata(Metadata[] prototype, File localFile) throws IOException {
        Metadata[] storedMetadata = this.getMetadata(localFile);
        for (int i = 0; i < prototype.length; ++i) {
            for (int j = 0; j < storedMetadata.length; ++j) {
                if (!prototype[i].field.equals(storedMetadata[j].field)) continue;
                prototype[i].value = storedMetadata[j].value;
            }
        }
    }

    public Metadata[] getAllMetadata(File localFile) throws IOException {
        return this.getAllMetadata(localFile);
    }

    public Metadata[] getMetadata(File localFile) throws IOException {
        Metadata[] storedMetadata;
        try {
            File dir = localFile.getParentFile();
            File metadataFile = new File(dir, localFile.getName() + METADATA_FILE_SUFFIX);
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(metadataFile)));
            storedMetadata = (Metadata[])in.readObject();
            in.close();
        }
        catch (FileNotFoundException ex) {
            storedMetadata = new Metadata[]{};
        }
        catch (ClassNotFoundException ex) {
            storedMetadata = new Metadata[]{};
            ex.printStackTrace();
        }
        return storedMetadata;
    }

    public boolean isMetadataFile(String fileName) {
        return fileName.endsWith(METADATA_FILE_SUFFIX);
    }
}

