/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.text.SimpleDateFormat;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;

public abstract class LoggingInitializer {
    public static final String ATTR_LOG_VERBOSITY = "jacorb.log.default.verbosity";
    public static final String ATTR_LOG_FILE = "jacorb.logfile";
    public static final String ATTR_LOG_APPEND = "jacorb.logfile.append";
    public static final String ATTR_LOG_SIZE = "jacorb.logfile.maxLogSize";
    public static final String ATTR_LOG_ROTATE = "jacorb.logfile.rotateCount";
    public static final String ATTR_LOG_THREAD_ID = "jacorb.log.showThread";
    public static final String ATTR_LOG_SRC_INFO = "jacorb.log.showSrcInfo";
    public static final String ATTR_LOG_CLOCK = "jacorb.log.clockFormat";
    public static final String ATTR_LOG_NAME = "org.jacorb";

    protected String substituteImplname(String filename, Configuration config) {
        if (!filename.contains("$implname")) {
            return filename;
        }
        ORB orb = config.getORB();
        String serverId = orb != null ? orb.getServerIdString() : "orbsingleton-" + new SimpleDateFormat("yyyyMdHms").format(System.currentTimeMillis());
        String implName = config.getAttribute("jacorb.implname", serverId);
        if (filename.endsWith("$implname")) {
            return filename.substring(0, filename.length() - 9) + implName + ".log";
        }
        return filename.replace("$implname", implName);
    }

    public abstract void init(Configuration var1) throws ConfigurationException;

    public void shutdownLogging() {
    }
}

