/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.SecurityLevel2.Current;
import org.slf4j.Logger;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Configurable {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = "ServerInvocationInterceptor";
    private AttributeType type = null;
    private HashMap sessionCredentials = new HashMap();
    private Logger logger;
    private int serverSupportedOptions = 0;
    private int serverRequiredOptions = 0;

    public ServerInvocationInterceptor(Current current, ORB orb) throws ConfigurationException {
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
        this.configure(orb.getConfiguration());
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("org.jacorb.security.ssl.interceptor");
        this.serverSupportedOptions = configuration.getAttributeAsInteger("jacorb.security.ssl.server.supported_options", 32, 16);
        this.serverRequiredOptions = configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 0, 16);
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        CertificateFactory certificateFactory;
        SSLSocket sslSocket;
        block13: {
            GIOPConnection connection = ((ServerRequestInfoImpl)ri).getConnection();
            if (connection == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("target has no connection!");
                }
                return;
            }
            if (!connection.isSSL()) {
                return;
            }
            if (!(connection.getTransport() instanceof ServerIIOPConnection)) {
                return;
            }
            ServerIIOPConnection transport = (ServerIIOPConnection)connection.getTransport();
            sslSocket = (SSLSocket)transport.getSocket();
            SSLSession session = sslSocket.getSession();
            if (this.sessionCredentials.containsKey(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Reusing SSL session credentials.");
                }
                return;
            }
            certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block13;
                this.logger.warn(e.getMessage());
            }
        }
        try {
            X509Certificate[] certs = sslSocket.getSession().getPeerCertificateChain();
            int size = certs.length;
            java.security.cert.X509Certificate[] newCerts = new java.security.cert.X509Certificate[size];
            for (int i = size - 1; 0 <= i; --i) {
                newCerts[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certs[i].getEncoded()));
            }
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception " + e.getMessage() + " in ServerInvocationInterceptor");
            }
            if ((this.serverRequiredOptions & 0x40) != 0) {
                throw new NO_PERMISSION("Establish trust in client required, but failed");
            }
            return;
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        this.removeAttribute();
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
    }

    private void removeAttribute() {
    }
}

