/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.streamblockingnio;

import csfs.impl.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public class StreamBlockingNIOReceiverThread
extends Thread {
    private Socket socket;
    private String rootDir;
    public static final int HEADER_SIZE = 7;

    public StreamBlockingNIOReceiverThread(Socket socket, String rootDir) {
        this.socket = socket;
        this.rootDir = rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel socketChannel = null;
        ByteBuffer response = ByteBuffer.allocate(1);
        try {
            socketChannel = this.socket.getChannel();
            try {
                ByteBuffer headerSizeBuf = ByteBuffer.allocate(7);
                for (int headerSizeAlreadyRead = 0; headerSizeAlreadyRead < 7; headerSizeAlreadyRead += socketChannel.read(headerSizeBuf)) {
                }
                headerSizeBuf.rewind();
                int headerSize = (int)Util.readLongFromBuffer(headerSizeBuf);
                ByteBuffer headerBuf = ByteBuffer.allocate(headerSize);
                for (int headerAlreadyRead = 0; headerAlreadyRead < headerSize; headerAlreadyRead += socketChannel.read(headerBuf)) {
                }
                headerBuf.rewind();
                long offset = Util.readLongFromBuffer(headerBuf);
                long length = Util.readLongFromBuffer(headerBuf);
                long diskOp = Util.readLongFromBuffer(headerBuf);
                String path = Util.readStringFromBuffer(headerBuf);
                if (diskOp == 1L) {
                    this.writeDataToDisk(socketChannel, offset, path, length);
                } else {
                    this.readDataToNull(socketChannel, length);
                }
                response.put(0, (byte)0);
            }
            catch (IOException e) {
                response.put(0, (byte)1);
            }
            finally {
                if (socketChannel != null) {
                    socketChannel.write(response);
                    socketChannel.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void writeDataToDisk(SocketChannel socketChannel, long offset, String path, long length) throws FileNotFoundException, IOException {
        while (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        path = Util.systemFileSeparatorToLocalFileSeparator(path);
        RandomAccessFile file = new RandomAccessFile(new File(this.rootDir, path).getAbsolutePath(), "rw");
        FileChannel fileChannel = file.getChannel();
        fileChannel.position(offset);
        for (long transferred = 0L; length > transferred; transferred += fileChannel.transferFrom(socketChannel, offset + transferred, length - transferred)) {
        }
        fileChannel.close();
    }

    private void readDataToNull(SocketChannel socketChannel, long length) throws IOException {
        int bufSize = (int)Math.min(0x100000L, length);
        ByteBuffer nullReader = ByteBuffer.allocate(bufSize);
        for (long transfered = 0L; transfered < length; transfered += (long)socketChannel.read(nullReader)) {
            if (length - transfered < (long)bufSize) {
                bufSize = (int)(length - transfered);
                nullReader = ByteBuffer.allocate(bufSize);
            }
            nullReader.rewind();
        }
    }
}

