/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.typecode;

import java.util.Map;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.typecode.AbstractTypeCodeReader;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TypeCode;
import org.slf4j.Logger;

public class IndirectionTypeCodeReader
extends AbstractTypeCodeReader {
    @Override
    protected TypeCode doReadTypeCode(CDRInputStream in, Map recursiveTCMap, Map repeatedTCMap, Integer startPosition, int kind) {
        TypeCode repeatedTC;
        Logger logger = ((ORB)in.orb()).getLogger();
        int negative_offset = in.read_long();
        Integer origTCStartPos = in.get_pos() - 4 + negative_offset;
        if (logger.isDebugEnabled()) {
            logger.debug(in.getIndentString() + "  startPosition: " + startPosition);
            logger.debug(in.getIndentString() + "  negative offset: " + negative_offset);
            logger.debug(in.getIndentString() + "  calculated position: " + origTCStartPos);
            logger.debug(in.getIndentString() + "  repeated TC map: " + repeatedTCMap);
            logger.debug(in.getIndentString() + "  recursive TC map: " + recursiveTCMap);
        }
        if ((repeatedTC = (TypeCode)repeatedTCMap.get(origTCStartPos)) != null) {
            return repeatedTC;
        }
        String recursiveId = (String)recursiveTCMap.get(origTCStartPos);
        if (recursiveId != null) {
            return this.orb.create_recursive_tc(recursiveId);
        }
        throw new MARSHAL("Found indirection marker, but no corresponding original typecode (pos: " + origTCStartPos + ")");
    }
}

