MICO=/home/t/tecgraf/prod/lib/wio/mico2.3.12
MICOINC = $(MICO)/include/$(TEC_UNAME)

LIBNAME = wiolibcpp
PROJNAME = wiolibcpp

#DBG = YES

TARGETROOT = $(PROJDIR)/lib
DEFINES = HAVE_EXCEPTIONS #WIO_DEBUG
INCLUDES = ../include . $(MICOINC)
LDIR += $(MICO)/lib/$(TEC_UNAME)

IDL_ARGS = --c++-suffix cpp

ifeq "$(TEC_SYSNAME)" "Win32"
  CPPFLAGS += -Zm1024 -GX -GR -EHsc -GS -wd4290
  DEFINES += _WINDOWS _WIN32
  ifeq "$(TEC_UNAME)" "dll7"
    DEFINES += WIO_DLL_MAKE_EXPORT
    LIBS += mico2312
  endif
  MICO=t:/prod/lib/wio/mico2.3.12
  IDL_CMD = $(MICO)/bin/Win32/idl.exe
  USE_MT = YES
else
  DEFINES += _FILE_OFFSET_BITS=64
  CPPFLAGS += -g
  IDL_CMD = $(MICO)/bin/$(TEC_UNAME)/idl
endif


SRC = \
   WIOFileSystemImpl.cpp \
   WIOProjectImpl.cpp \
   WIOFileImpl.cpp \
   WIODateTimeInfo.cpp \
   WIOLocator.cpp \
   Exception.cpp \
   wio.cpp \
   util.cpp

INC = var.h wioapi.h wioapiimpl.h wio.h util.h

klean:
	rm wio.h wio.cpp

wio.h wio.cpp : ../../../csbase/idl/wio.idl 
	$(IDL_CMD) $(IDL_ARGS) $<

doc:
	mkdoxygen 'WIO3,C++' brazilian /home/t/tecgraf/prod/app/csbase/html/wio/doxygen-libcpp "wioapi.h util.h" 
