#include <errno.h>
#include <string.h>
#include <time.h>

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include "wioapi.h"
#include "util.h"

using namespace std;
using namespace wioapi;


bool pertence(const char* str, char** lista, long size);

bool doit(const char* cmd, WIOProject* proj, WIOFile* currentDir,
long readPackSize, long writePackSize, const char* user) 
throw (wioapi::Exception*);

void listDirectoryFiles(WIOFile* root, bool recursive) 
throw (wioapi::Exception*);

void listDirectoryDescriptions(WIOFile* root) throw (wioapi::Exception*);

/**
  Extrai o endereco/porta do servidor dos parametros da linha de comando.
*/
char* getParameter(const char* cmdOption, int argc, 
char *argv[], bool mandatory) {
  for (int i=0; i<argc; i++) {
     // se um dos parametros da linha de comando comeca por ...
     if (strstr(argv[i], cmdOption) == argv[i]) {
          cout << cmdOption << " = " << argv[i+1] << endl;
          return i < argc ? argv[i+1] : NULL;
     }
  }
  if (mandatory) {
    cout << "No parameter: " << cmdOption << endl;
    cout << "Usage:\nwioftp --user <user> --shared-user <user> " <<
              "--passwd <pwd> --server <server> --port <port> " <<
              "--project <project>" <<
              "--ior <ior> --cmd <remote-file> " <<
              "--cmd-local <path> --cmd-remote <path> --cmd-loop true" <<
              "--cmd-prompt true " <<
              "\n" 
              << endl;

    exit(1);
  }
   return NULL;
}

int main( int argc, char *argv[] ) {

  WIOFileSystem* wioFileSystem = NULL;
  WIOProject* proj = NULL;
  WIOFile* currentDir = NULL;
  
  try {
    const char* user = getParameter("--user", argc, argv, true);
    const char* suser = getParameter("--shared-user", argc, argv, false);
    const char* pwd = getParameter("--passwd", argc, argv, true);
    const char* server = getParameter("--server", argc, argv, true);
    const char* port = getParameter("--port", argc, argv, true);
    const char* project = getParameter("--project", argc, argv, false);
    const char* cmd = getParameter("--cmd", argc, argv, false);
    const char* loop = getParameter("--cmd-loop", argc, argv, false);
    const char* prompt = getParameter("--cmd-prompt", argc, argv, false);
    const char* cmdld = getParameter("--cmd-local", argc, argv, false);
    const char* cmdre = getParameter("--cmd-remote", argc, argv, false);
    const char* ior = getParameter("--ior", argc, argv, false);

      void* orb = WIOLocator::startORB(argc, argv);
      if (orb == NULL) {
       cout << "No ORB found! Bye!" << endl;
       exit(1);
      }

      if (ior == NULL) ior = WIOLocator::createIOR(server, port);
      cout << "IOR for file system: " << endl << ior << endl;
    wioFileSystem = WIOLocator::buildFileSystem(ior);
      cout << "File system built!" << endl;
    cout << "WIO Server Version: : [" << wioFileSystem->getServerVersion() << 
      "]" <<  endl << endl;
    char* separator = wioFileSystem->getSeparatorChar();
    cout << "The separator char is \"" << separator << "\"" << endl;
    // delete[] separator;
  
    long numProjs;
      char** projects = NULL;
      if (suser == NULL) {
         projects = wioFileSystem->getProjects(user, pwd, numProjs);
      }
      else {
         SharedProjectInfo* infos = wioFileSystem->getProjectsFromOthers(
               user, pwd, numProjs);
         int np = 0;
         for (int p = 0; p < numProjs; p++) {
             if (!strcmp(infos[p].ownerId, suser)) np++;
         }
         projects = new char*[np];
         for (int r = 0; r < numProjs; r++) {
             if (!strcmp(infos[r].ownerId, suser)) {
                 projects[r] = (char*)infos[r].projectId;
             }
         }
      }

      long rSize = wioFileSystem->getMaxReadKb() * 1024;
      long wSize = wioFileSystem->getMaxWriteKb() * 1024;
    cout << "Max. read size: " << rSize/1024 << " Kbytes" << endl;
    cout << "Max. write size: " << wSize/1024 << " Kbytes" << endl;
    char selProject[200];
    
      if (project && pertence(project, projects, numProjs)) {
         strcpy(selProject, project);
       cout << "Project selected: [" << project << "]" <<  endl;
      }
      else {
       do {
         cout << "projects are:" << endl;
         for(int i=0; i<numProjs; i++) {
           cout << "  -> [" << projects[i] << "]" << endl;
         }
         cout << "$ ";
         cin >> selProject;
       } while(!pertence(selProject, projects, numProjs));
      }
    
    cout << "Opening project: [" << selProject << "]" <<  endl;
      if (suser == NULL) {
       proj = wioFileSystem->openProject(user, pwd, selProject);
      }
      else {
       proj = wioFileSystem->openProjectFromOthers(
            user, pwd, suser, selProject);
      }

    cout << "Taking root directory for:  " << selProject << endl; 
    currentDir = proj->getRootFile();

      if (cmd) {
         char trash[12];
       cout << "Processing command: [" << cmd << "]" <<  endl;
         if (prompt) {
          cout << "Type x+[ENTER] to start..." << endl;
            cin >> trash;
         }
         if (!strcmp(cmd, "get")) {
            if (cmdld && cmdre) get(cmdld, cmdre, proj, user, rSize);
         }
         if (!strcmp(cmd, "put")) {
            if (cmdld && cmdre) put(cmdld, cmdre, proj, user, wSize);
         }
         else if (!strcmp(cmd, "ls")) {
          listDirectoryFiles(currentDir, false);
         }
         else if (!strcmp(cmd, "desc")) {
          listDirectoryDescriptions(currentDir);
         }
      cout << "Comand finished! Exiting..." << endl;
         if (loop) {
          cout << "Type x+[ENTER] to finish..." << endl;
            cin >> trash;
         }
      }
      else {
         char command[100];
       do {
         cout << "$ ";
         cin >> command;
       } while(doit(command, proj, currentDir, rSize, wSize, user));
      }
  }
  catch(wioapi::Exception* ex) {
    cout << "EXCEPTION FOR WIO DETECTED! AHHH!" << endl;
    cout << ex->getServerMessage() << endl;
    cout << ex->getClientMessage() << endl;
  }
  
  delete wioFileSystem;
  delete proj;
  delete currentDir;
  
  return 0;
}

bool pertence(const char* str, char** lista, long size)
{
  for(int i=0; i<size; i++)
  {
    if(strcmp(lista[i], str) == 0)
    {
      return true;
    }
  }
  
  return false;
}

static char* gettime(void) {
  static char b[256];
  struct tm *tm;
  char* s = "%H:%M:%S\n";
  time_t t;
  time(&t); tm = localtime(&t);
  strftime(b,sizeof(b),s,tm);
  return b;
}

bool doit(const char* cmd, WIOProject* proj, WIOFile* currentDir,
long readPackSize, long writePackSize, const char* user) 
throw (wioapi::Exception*) {

  if(strcmp(cmd, "ls") == 0) {
    listDirectoryFiles(currentDir, false);
  }
  else if(strcmp(cmd, "desc") == 0) {
    listDirectoryDescriptions(currentDir);
  }
  else if(strcmp(cmd, "tree") == 0) {
    listDirectoryFiles(currentDir, true);
  }
  else if(strcmp(cmd, "put") == 0) {
      cout << "Arq. local:\n";
    char localFile[100];
    cin >> localFile;

      cout << "Arq. remoto:\n";
    char remoteFile[100];
    cin >> remoteFile;

      cout << gettime();
    put(localFile, remoteFile, proj, user, writePackSize);
      cout << gettime();
  }
  else if(strcmp(cmd, "get") == 0) {
      cout << "Arq. local:\n";
    char localFile[100];
    cin >> localFile;

      cout << "Arq. remoto:\n";
    char remoteFile[100];
    cin >> remoteFile;

      cout << gettime();
    get(localFile, remoteFile, proj, user, readPackSize);
      cout << gettime();
  }
  else if (strcmp(cmd, "mv") == 0) {
    char from[100];
    char to[100];
    cin >> from;
    cin >> to;
    proj->moveFile(from, to); 
    cout << "mv " << from << " -> " << to << endl;
  }
  else if (strcmp(cmd, "cp") == 0) {
    char from[100];
    char to[100];
    cin >> from;
    cin >> to;
    proj->copyFile(from, to);
    cout << "cp " << from << " -> " << to << endl;
  }
  else if (strcmp(cmd, "rm") == 0) {
    char filename[100];
    cin >> filename;
    proj->deleteFile(filename);
  }
  else if(strcmp(cmd, "quit") == 0) {
      cout << "Bye!\n";
    return false;
  }
  
  return true;
}

void listDirectoryFiles(WIOFile* root, bool recursive) 
throw (wioapi::Exception*) {
  static int indent = -1;
  
  indent++;
  int nfiles = root->getNumFiles();
  cout << nfiles << " file(s)." << endl;
  for(int i = 0; i < nfiles; i++) {
    WIOFile* file = root->getFile(i);
    if (file == NULL) {
       cout << "o arq eh null" << endl;
       continue;
    }

    for(int j=0; j<indent; j++) {
      cout << "  ";
    }
    
    char* path = file->getPath();
    char* author = file->whoCreated();
    WIODateTimeInfo* creation = file->creationTime();
    WIODateTimeInfo* last = file->lastModificationTime();
    long long size = (file->isDirectory())? 0 : file->size();
    const char* pub = file->isPublished() ? "P" : "";
    const char* und = file->isPublished() ? "U" : "";

    cout << "  " << (i+1) << ") " << 
           path << ((file->isDirectory())?"/":"") << 
           " " << pub << und << " " <<
           " (" << author << ")" <<
           " - [M: " << last->dump() << "]" <<
           " - [C: " << creation->dump() << "]" <<
           " > [tam: " << (double)size/1024./1024. << " Mb"  << "]" <<
           endl;

    delete creation;
    delete last;

    if (recursive && file->isDirectory()) {
      listDirectoryFiles(file, true);
    }
    delete file;
  }
  
  indent--;
}


void listDirectoryDescriptions(WIOFile* root) throw (wioapi::Exception*) {
  int nfiles = root->getNumFiles();
  cout << nfiles << " file(s)." << endl;

  for (int i = 0; i < nfiles; i++) {
      WIOFile* file = root->getFile(i);
      if (file == NULL) {
         cout << "o arq eh null" << endl;
         continue;
      }
    
      char* path = file->getPath();
      char* desc = (char*)(file->isDirectory() ? 
             "[DIR]" : 
             file->getDescription());

      cout << (i+1) << ") " << endl <<
           path << ((file->isDirectory())?"/":"") << endl << desc << 
           endl << endl;

      delete file;
  }
}

