package csdk.v2.api.core;

import java.io.Serializable;

/**
 * Base para os contextos CSDK.
 */
public interface IContext extends Serializable {

  /**
   * Mtodo de ativao do contexto.
   */
  public void onContextActivate();

  /**
   * Determina se o contexto est ativo.
   * 
   * @return <code>true</code> se o contexto est ativo ou <code>false</code>
   *         caso contrrio.
   */
  public boolean isActive();

  /**
   * Mtodo de desativao do contexto.
   */
  public void onContextDeactivate();

}
