package csdk.v2.api.command;

import java.util.Map;

import csdk.v2.api.filesystem.IFile;

/**
 * Define as informaes do fluxo a ser executado.
 */
public interface IFlowTemplate {

  /**
   * Obtm o nome do fluxo de algoritmos.
   * 
   * @return o nome do fluxo de algoritmos
   */
  public String getFlowName();

  /**
   * Obtm o identificador da verso do fluxo de algoritmos.
   * 
   * @return o identificador da verso do fluxo de algoritmos
   */
  public String getFlowVersionId();

  /**
   * Obtm o caminho para o arquivo de definio de fluxo, caso no esteja
   * instalado.
   * 
   * @return flow o caminho.
   */
  public IFile getFlowDefinitionFile();

  /**
   * Obtm um mapa com os valores dos parmetros a serem inicializados no fluxo
   * de algoritmos, indexados pelo identificador numrico do algoritmo no fluxo.
   * 
   * @return um mapa com os valores dos parmetros do fluxo por algoritmo.
   */
  public Map<Integer, IAlgorithmTemplate> getParametersValuesByNodeId();

}
