package csdk.v2.api.user;

import java.io.Serializable;

/**
 * Representa um usurio do sistema.
 */
public interface IUser extends Serializable {

  /**
   * Obtm o login do usurio.
   * 
   * @return o login do usurio
   */
  public String getLogin();

  /**
   * Obtm o nome do usurio.
   * 
   * @return o nome do usurio
   */
  public String getName();

  /**
   * Obtm os emails do usurio.
   * 
   * @return o conjunto de emails do usurio ou um array vazio caso o usurio
   *         no tenha nenhum e-mail cadastrado.
   */
  public String[] getEmails();

  /**
   * Verifica se o usurio  o administrador.
   * 
   * @return <code>true</code> se o usurio for o administrador,
   *         <code>false</code> caso contrrio
   */
  public boolean isAdmin();

}
