/**
 * $Id: ListParameter.java 131406 2012-07-24 19:21:30Z fpina $
 */
package csdk.v2.helper.command.parameters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Valor genrico para parmetros do tipo List de um tipo {@code <T>}.
 * 
 * @param <T> tipo do valor da lista.
 */
public abstract class ListParameterValue<T> extends
  AbstractParameterValue<List<T>> {

  /**
   * Construtor.
   */
  public ListParameterValue() {
    super(new ArrayList<T>());
  }

  /**
   * Construtor.
   * 
   * @param values lista de valores.
   */
  public ListParameterValue(List<T> values) {
    super(values);
  }

  /**
   * Construtor.
   * 
   * @param values array de valores.
   */
  public ListParameterValue(T[] values) {
    super(Arrays.asList(values));
  }

  /**
   * Adiciona um novo valor  lista.
   * 
   * @param value o valor.
   */
  public void addValue(T value) {
    getValue().add(value);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ParameterValueConverter<List<T>> getValueConverter() {
    return new ListValueConverter<T>(getSingleValueConverter());
  }

  /**
   * Obtm o conversor de uma unidade do tipo {@code <T>} para string.
   * 
   * @return o conversor.
   */
  protected ParameterValueConverter<T> getSingleValueConverter() {
    return new DefaultValueConverter<T>();
  }
}
