package csdk.v1_0.helper.command.parameters;

/**
 * Valor de parmetros do tipo arquivo.
 */
public class FileParameterValue extends AbstractParameterValue<URL> {

  /**
   * Construtor.
   * 
   * @param path o caminho para o arquivo.
   * @param type o tipo do arquivo.
   */
  public FileParameterValue(String path, String type) {
    super(new URL(path, type));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ParameterValueConverter<URL> getValueConverter() {
    return new URLValueConverter();
  }

}
