/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.helper.application;

import csdk.v1_0.helper.application.AbstractApplication;
import csdk.v1_0.helper.application.AbstractWindowApplicationAction;
import csdk.v1_0.helper.application.ApplicationImages;
import csdk.v1_0.helper.application.HelperBundle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ApplicationAboutAction
extends AbstractWindowApplicationAction<AbstractApplication> {
    public ApplicationAboutAction(AbstractApplication application, Window frame) {
        super(application, frame);
        Locale locale = application.getLocale();
        String label = HelperBundle.getString(locale, this.getClass(), "name");
        String tooltip = HelperBundle.getString(locale, this.getClass(), "tooltip");
        ImageIcon icon = ApplicationImages.ICON_ABOUT_16;
        this.setName(label);
        this.setTooltip(tooltip);
        this.setIcon(icon);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object application = this.getApplication();
        String applicationId = ((AbstractApplication)application).getApplicationId();
        String authorName = ((AbstractApplication)application).getAuthor();
        String authorMail = ((AbstractApplication)application).getAuthorEmail();
        String versionNumber = ((AbstractApplication)application).getVersion();
        String applicationName = ((AbstractApplication)application).getApplicationName();
        String description = ((AbstractApplication)application).getApplicationDescription();
        StringBuilder messageBuilder = new StringBuilder();
        if (applicationName != null) {
            messageBuilder.append(applicationName);
            messageBuilder.append(" [");
            messageBuilder.append(applicationId);
            messageBuilder.append("]");
        } else {
            messageBuilder.append(applicationId);
        }
        if (description != null) {
            messageBuilder.append("\n");
            messageBuilder.append(description);
        }
        messageBuilder.append("\n");
        if (authorName != null) {
            messageBuilder.append("\n");
            messageBuilder.append(authorName);
        }
        if (authorMail != null) {
            messageBuilder.append("\n");
            messageBuilder.append(authorMail);
        }
        if (versionNumber != null) {
            messageBuilder.append("\n");
            messageBuilder.append(versionNumber);
        }
        ImageIcon icon = ((AbstractApplication)application).getApplicationIcon();
        JOptionPane.showMessageDialog(this.getWindow(), messageBuilder, applicationId, 1, icon);
    }
}

