package csdk.v1_0.helper.application;

import java.awt.Window;

/**
 * Ao genrica de uma aplicao com janela com criao de textos e imagens da
 * prpria aplicao.
 * 
 * @author Tecgraf/PUC-Rio
 * @param <A> a classe da aplicao.
 */
public abstract class AbstractWindowApplicationAction<A extends AbstractApplication>
  extends AbstractApplicationAction<A> {

  /**
   * Janela me da ao.
   */
  private final Window window;

  /**
   * Construtor.
   * 
   * @param application a aplicao
   * @param window janela me da ao.
   */
  public AbstractWindowApplicationAction(A application, Window window) {
    super(application);
    this.window = window;
  }

  /**
   * Obtm a janela me da ao.
   * 
   * @return a janela.
   */
  public Window getWindow() {
    return window;
  }

}
