package csdk.v1_0.helper.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import csdk.v1_0.api.command.IAlgorithmTemplate;
import csdk.v1_0.helper.command.parameters.IParameterValue;
import csdk.v1_0.helper.command.parameters.ParameterValueConvertionException;

/**
 * Utilitrio para auxiliar a configurao de algoritmos para o contexto de
 * execuo.
 */
public class TemplateHelper {

  /**
   * Mapa de valores dos parmetros, indexado pelo nome.
   */
  private final Map<String, String> values;

  /**
   * Construtor.
   */
  public TemplateHelper() {
    this.values = new HashMap<String, String>();
  }

  /**
   * Adiciona um novo valor de parmetro.
   * 
   * @param parameterId o nome do parmetro.
   * @param parameter o valor do parmetro.
   * 
   * @throws ParameterValueConvertionException em caso de valor invlido.
   */
  public void addParameterValue(String parameterId, IParameterValue<?> parameter)
    throws ParameterValueConvertionException {
    values.put(parameterId, parameter.getValueAsString());
  }

  /**
   * Gera o mapa de valores de parmetros a ser usado para configurar o
   * algoritmo {@link IAlgorithmTemplate}
   * 
   * @return map o mapa de valores.
   */
  public Map<String, String> generateParameterValuesMap() {
    return Collections.unmodifiableMap(values);
  }

}
