package csdk.v2.rest.helper;

import javax.ws.rs.core.Response;

import csdk.v2.helper.application.AbstractApplication;
import csdk.v2.helper.application.Message;
import csdk.v2.helper.application.MessageSender;

/**
 * Resource bsico para atendimento  aplicaes
 *
 * @param <A> classe de aplicao.
 */
public class ApplicationRestResource<A extends AbstractApplication> {

  /**
   * Sender interno (fake)
   */
  private final static String MESSAGE_SENDER_ID = "ApplicationRestClient";

  /**
   * Aplicao.
   */
  private final A application;

  /**
   * Construtor.
   *
   * @param application aplicao.
   */
  public ApplicationRestResource(A application) {
    this.application = application;
  }

  /**
   * @return aplicao
   */
  public A getApplication() {
    return application;
  }

  /**
   * Tratador interno de mensagens sync.
   *
   * @param type tipo da mensagem
   * @param param valor
   * @return response.
   */
  public Response handleSyncMessage(String type, Object param) {
    Message msg = new Message(type, param);
    MessageSender sender = new MessageSender(MESSAGE_SENDER_ID,
      MESSAGE_SENDER_ID);

    try {
      Object response = application.onSyncMessageReceived(msg, sender);
      return Response.ok().entity(response).build();
    }
    catch (Throwable ex) {
      //TODO tratar erros de parametros incorretos ou em formato errado
      return Response.serverError().entity(ex.getLocalizedMessage()).build();
    }
  }

  /**
   * Tratador interno de mensagens async.
   *
   * @param type tipo da mensagem
   * @param param valor
   * @return response.
   */
  public Response handleAsyncMessage(String type, Object param) {
    Message msg = new Message(type, param);
    MessageSender sender = new MessageSender(MESSAGE_SENDER_ID,
      MESSAGE_SENDER_ID);

    try {
      application.onAsyncMessageReceived(msg, sender);
      return Response.ok().entity("").build();
    }
    catch (Throwable ex) {
      //TODO tratar erros de parametros incorretos ou em formato errado
      return Response.serverError().entity(ex.getLocalizedMessage()).build();
    }
  }

}
