package csdk.v2.rest.helper;

import java.util.List;

import org.glassfish.jersey.server.ResourceConfig;

import csdk.v2.api.application.IApplication;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.extras.context.rest.IRestContext;
import csdk.v2.extras.context.rest.RestException;

/**
 * Controlador bsico de registro de recurso de aplicaes
 *
 * @param <A> classe da aplicao.
 */
public abstract class ApplicationRestController <A extends IApplication> {

  /**
   * O ambiente CSDK.
   */
  private final ICSDKEnvironment environment;

  /**
   * Construtor
   *
   * @param environment o ambiente CSDK.
   */
  public ApplicationRestController(ICSDKEnvironment environment) {
    this.environment = environment;
  }

  /**
   * Registro dos objetos definidos para recursos REST ({@link #getResources()}
   *
   * @throws RestException em caso de falha no regitro.
   */
  public void register() throws RestException {
    IRestContext context = environment.getContext(IRestContext.class);
    ResourceConfig rc = new ResourceConfig();
    rc.registerInstances(getResources().toArray());
    context.registerResources(rc);
  }

  /**
   * Consulta a lista de objetos de recursos que devem ser registrados pela
   * instncia da aplicao.
   *
   * @return lista
   */
  public abstract List<ApplicationRestResource<A>> getResources();

}
