package csdk.v2.rest.helper;

import csdk.v2.api.application.IApplication;
import csdk.v2.rest.helper.exception.JSONException;

/**
 * Resource bsico para atendimento  aplicaes
 *
 * @param <A> classe de aplicao.
 */
public class ApplicationRestResource <A extends IApplication> {

  /**
   * Aplicao.
   */
  private final A application;

  /**
   * Construtor.
   *
   * @param application aplicao.
   */
  public ApplicationRestResource(A application) {
    this.application = application;
  }

  /**
   * @return aplicao
   */
  public A getApplication() {
    return application;
  }

  /**
   * Mtodo para converter String JSON em um Mapa
   *
   * @param body A mensagem JSON a ser convertida
   * @return Um Mapa contendo os campos definidos no JSON
   * @throws JSONException Em caso de erros de sintaxe na mensagem JSON
   */
  protected JSONMap parseJSON(String body) throws JSONException {
    return new JSONMap(body);
  }

}
