/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.helper.application;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.core.IContext;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.helper.ContextNotAvailableException;
import java.awt.Window;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.swing.ImageIcon;

public abstract class AbstractApplication
implements IApplication,
ICSDKEnvironment,
IApplicationContext {
    private IApplicationContext context;
    private ICSDKEnvironment csdkInterface;

    protected AbstractApplication(ICSDKEnvironment csdkInterface) {
        this.csdkInterface = csdkInterface;
        this.context = csdkInterface.getContext(IApplicationContext.class);
    }

    @Override
    public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
    }

    @Override
    public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
        return null;
    }

    @Override
    public boolean canEndApplication() {
        return true;
    }

    @Override
    public boolean hasString(String key) {
        this.checkApplicationContext();
        return this.context.hasString(key);
    }

    @Override
    public String getString(String key, Object ... objs) {
        this.checkApplicationContext();
        return this.context.getString(key, objs);
    }

    @Override
    public String getApplicationId() {
        this.checkApplicationContext();
        return this.context.getApplicationId();
    }

    @Override
    public String getInstanceId() {
        this.checkApplicationContext();
        return this.context.getInstanceId();
    }

    @Override
    public boolean isPropertyNull(String propName) {
        this.checkApplicationContext();
        return this.context.isPropertyNull(propName);
    }

    @Override
    public boolean isBundleRequired() {
        this.checkApplicationContext();
        return this.context.isBundleRequired();
    }

    @Override
    public String getProperty(String propName) {
        this.checkApplicationContext();
        return this.context.getProperty(propName);
    }

    @Override
    public String getApplicationName() {
        this.checkApplicationContext();
        return this.context.getApplicationName();
    }

    @Override
    public ImageIcon getImageIcon(String[] path) {
        this.checkApplicationContext();
        return this.context.getImageIcon(path);
    }

    private String getPackageName(Class<?> clazz) {
        String className = clazz.getName();
        int index = className.lastIndexOf(".");
        String packageName = index != -1 ? className.substring(0, index) : "";
        return packageName;
    }

    private String getResourcePath(String[] path) {
        String sep = "/";
        Class<?> baseClass = this.getClass();
        String packageName = this.getPackageName(baseClass);
        StringBuilder resPath = new StringBuilder();
        resPath.append(packageName.replace(".", "/"));
        resPath.append(sep);
        resPath.append("resources");
        resPath.append(sep);
        for (String pathElement : path) {
            resPath.append(pathElement);
            resPath.append(sep);
        }
        resPath.deleteCharAt(resPath.length() - 1);
        return resPath.toString();
    }

    public URL getResource(String[] path) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String resourcePath = this.getResourcePath(path);
            return classLoader.getResource(resourcePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String[] path) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String resourcePath = this.getResourcePath(path);
            return classLoader.getResourceAsStream(resourcePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Charset getCharset(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        switch (file.getFileLocationType()) {
            case LOCAL: {
                return this.getCharset();
            }
            case REMOTE: {
                return this.getServerCharset();
            }
        }
        throw new IllegalStateException("Cannot determine charset");
    }

    @Override
    public ImageIcon getSmallApplicationIcon() {
        this.checkApplicationContext();
        return this.context.getSmallApplicationIcon();
    }

    @Override
    public ImageIcon getApplicationIcon() {
        this.checkApplicationContext();
        return this.context.getApplicationIcon();
    }

    @Override
    public String getVersion() {
        this.checkApplicationContext();
        return this.context.getVersion();
    }

    @Override
    public String getApplicationDescription() {
        this.checkApplicationContext();
        return this.context.getApplicationDescription();
    }

    @Override
    public String getAuthor() {
        this.checkApplicationContext();
        return this.context.getAuthor();
    }

    @Override
    public String getAuthorEmail() {
        this.checkApplicationContext();
        return this.context.getAuthorEmail();
    }

    @Override
    public boolean isSingleton() {
        this.checkApplicationContext();
        return this.context.isSingleton();
    }

    @Override
    public boolean requiresProject() {
        this.checkApplicationContext();
        return this.context.requiresProject();
    }

    @Override
    public String[] getApplicationFileTypes() {
        this.checkApplicationContext();
        return this.context.getApplicationFileTypes();
    }

    @Override
    public String runApplication(String id) throws ApplicationException {
        return this.csdkInterface.runApplication(id);
    }

    @Override
    public void sendAsyncMessage(String instanceId, IMessage message) throws ApplicationException {
        this.csdkInterface.sendAsyncMessage(instanceId, message);
    }

    @Override
    public Object sendSyncMessage(String instanceId, IMessage message) throws ApplicationException {
        return this.csdkInterface.sendSyncMessage(instanceId, message);
    }

    @Override
    public void broadcastAsyncMessage(IMessage message) throws ApplicationException {
        this.csdkInterface.broadcastAsyncMessage(message);
    }

    @Override
    public void finishApplication() {
        this.csdkInterface.finishApplication();
    }

    @Override
    public <T extends IContext> T getContext(Class<T> contextClass) {
        return this.csdkInterface.getContext(contextClass);
    }

    @Override
    public void handleException(Exception error, Window parent) {
        this.csdkInterface.handleException(error, parent);
    }

    @Override
    public Locale getLocale() {
        return this.csdkInterface.getLocale();
    }

    @Override
    public Charset getCharset() {
        return this.csdkInterface.getCharset();
    }

    @Override
    public Charset getServerCharset() {
        return this.csdkInterface.getServerCharset();
    }

    public boolean isApplicationContextAvailable() {
        return this.context != null && this.context.isActive();
    }

    private void checkApplicationContext() {
        if (!this.isApplicationContextAvailable()) {
            throw new ContextNotAvailableException(IApplicationContext.class);
        }
    }

    @Override
    public void onContextActivate() {
    }

    @Override
    public void onContextDeactivate() {
    }

    @Override
    public boolean isActive() {
        return false;
    }

    public boolean hasClassString(Class<?> clazz, String key_suffix) {
        String classPrefix = clazz.getSimpleName();
        return this.hasString(classPrefix + "." + key_suffix);
    }

    public String getClassString(Class<?> clazz, String key_suffix, Object ... args) {
        String classPrefix = clazz.getSimpleName();
        return this.getString(classPrefix + "." + key_suffix, args);
    }

    @Override
    public void onApplicationEnd() throws ApplicationException {
        this.disposeContexts();
    }

    protected void disposeContexts() {
        this.csdkInterface = null;
        this.context = null;
    }
}

