package csdk.v2.runner;

/**
 * Propriedades da aplicao.
 */
public enum ApplicationParameters {

  /**
   * Identificador da chave de propriedade: nome do programa
   */
  APP_NAME_PROPERTY("name"),

  /**
   * Identificador da chave de propriedade: classe (Java) do programa
   */
  CLASS_NAME_PROPERTY("class.name"),

  /**
   * Identificador da chave de propriedade: Flag de necessidade de bundle.
   */
  NEED_BUNDLE_PROPERTY("need.bundle"),

  /**
   * Identificador da chave de propriedade: Cdigo da verso
   */
  VERSION_PROPERTY("version.number"),

  /**
   * Identificador da chave de propriedade: descrio do programa
   */
  DESCRIPTION_PROPERTY("description"),

  /**
   * Identificador da chave de propriedade: Flag de uso de prjetos.
   */
  REQUIRE_PROJECT_PROPERTY("require.project"),

  /**
   * Identificador da chave de propriedade: Nome do autor
   */
  AUTHOR_NAME_PROPERTY("author.name"),

  /**
   * Identificador da chave de propriedade: Email de contato do autor
   */
  AUTHOR_MAIL_PROPERTY("author.mail"),

  /**
   * Identificador da chave de propriedade: singleton
   */
  IS_SINGLETON_PROPERTY("singleton"),

  /**
   * Identificador da chave de propriedade: tipos de arquivos tratados
   */
  FILE_TYPES_PROPERTY("file.types"),

  /**
   * Identificador da chave de propriedade: classpath da aplicao.
   */
  CLASSPATH_PROPERTY("classpath");

  /**
   * Nome da propriedade.
   */
  private final String propertyName;

  /**
   * Construtor.
   * 
   * @param propertyName o nome da propriedade.
   */
  private ApplicationParameters(String propertyName) {
    this.propertyName = propertyName;
  }

  /**
   * Obtm o nome da propriedade formatado para a aplicao especificada.
   * 
   * @param id o identificador da aplicao.
   * @return o nome da propriedade.
   */
  public String getApplicationPropertyName(String id) {
    return id + "." + propertyName;
  }
}