package csdk.v2.runner.application;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.core.IContext;
import csdk.v2.api.filesystem.local.ILocalFileSystemContext;
import csdk.v2.api.user.IUser;
import csdk.v2.api.user.IUserContext;
import csdk.v2.api.user.UserException;
import csdk.v2.runner.ApplicationRegistry;
import csdk.v2.runner.CSDKLogger;
import csdk.v2.runner.IContextFactory;
import csdk.v2.runner.filesystem.local.LocalFileSystemContext;
import csdk.v2.runner.user.RunnerUser;
import csdk.v2.runner.user.RunnerUserContext;

/**
 * Fbrica padro de contextos do Runner.
 */
public class DefaultContextFactory implements IContextFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String instanceId, ApplicationRegistry registry, Properties properties) {
    Map<Class<? extends IContext>, IContext> contexts =
      new HashMap<Class<? extends IContext>, IContext>();
    contexts.put(IApplicationContext.class, new ApplicationContext(instanceId,
      registry));
    contexts.put(ILocalFileSystemContext.class, new LocalFileSystemContext(
      registry));
    try {
      RunnerUserContext userContext = createUserContext();
      contexts.put(IUserContext.class, userContext);
    }
    catch (UserException e) {
      CSDKLogger logger = CSDKLogger.getInstance();
      logger.logSevere("Error creating User Context!");
    }
    return contexts;
  }

  /**
   * Cria o contexto de usurios.
   *
   * @return o contexto de usurios.
   * @throws UserException - caso o usurio corrente no esteja definido no mapa
   *         de usurios.
   */
  protected RunnerUserContext createUserContext() throws UserException {
    Map<String, IUser> users = new HashMap<String, IUser>();
    String currentUserName = System.getProperty("user.name");
    IUser currentUser = new RunnerUser(currentUserName, currentUserName, null,
      false);
    String adminUserName = "admin";
    String[] adminMail = new String[] { "admin@admin.com" };
    IUser adminUser = new RunnerUser(adminUserName, adminUserName, adminMail,
      true);
    users.put(currentUserName, currentUser);
    users.put(adminUserName, adminUser);
    return new RunnerUserContext(users, currentUserName);
  }

}
