package csdk.v2.runner.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import csdk.v2.api.user.IUser;

/**
 * Um usurio do Runner.
 */
public class RunnerUser implements IUser {

  /**
   * O login do usurio.
   */
  private final String login;
  /**
   * O nome do usurio.
   */
  private final String name;
  /**
   * Os emails do usurio.
   */
  private final List<String> emails;
  /**
   * Indicativo se o usurio  administrador.
   */
  private final boolean isAdmin;

  /**
   * Construtor.
   * 
   * @param login o login do usurio.
   * @param name o nome do usurio.
   * @param emails os emails do usurio.
   * @param isAdmin <code>true</code> se o usurio for administrador ou
   *        <code>false</code> caso contrrio.
   */
  public RunnerUser(String login, String name, String[] emails, boolean isAdmin) {
    this.login = login;
    this.name = name;
    this.emails = new ArrayList<String>();
    if (emails != null && emails.length > 0) {
      this.emails.addAll(Arrays.asList(emails));
    }
    this.isAdmin = isAdmin;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    return login;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] getEmails() {
    return emails.toArray(new String[emails.size()]);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isAdmin() {
    return isAdmin;
  }

}