/*
 * Decompiled with CFR 0.152.
 */
package examples;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.application.IMessage;
import csdk.v1_0.api.application.IMessageSender;
import csdk.v1_0.api.command.CommandException;
import csdk.v1_0.api.command.IAlgorithmTemplate;
import csdk.v1_0.api.command.ICommandContext;
import csdk.v1_0.api.command.ICommandInfo;
import csdk.v1_0.api.command.ICommandObserver;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.helper.command.AlgorithmTemplate;
import csdk.v1_0.helper.command.parameters.ParameterValueConvertionException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CommandExecutionExample
implements IApplication {
    private final ICSDKEnvironment csdkInterface;
    private final IApplicationContext appContext;
    private final ICommandContext commandContext;
    private final JFrame mainFrame;

    public CommandExecutionExample(final ICSDKEnvironment csdkInterface) {
        this.csdkInterface = csdkInterface;
        this.appContext = (IApplicationContext)csdkInterface.getContext(IApplicationContext.class);
        this.commandContext = (ICommandContext)csdkInterface.getContext(ICommandContext.class);
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                csdkInterface.finishApplication();
            }
        });
    }

    public void onApplicationStart() throws ApplicationException {
        this.initUI();
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    public boolean canEndApplication() {
        int optionPaneType;
        String applicationName;
        String confirmMessage = this.appContext.getString("confirm.message", new Object[0]);
        int result = JOptionPane.showConfirmDialog(this.mainFrame, confirmMessage, applicationName = this.appContext.getApplicationName(), optionPaneType = 0);
        return result == 0;
    }

    public void onApplicationEnd() throws ApplicationException {
        this.mainFrame.dispose();
    }

    public void onMessageReceived(IMessage message, IMessageSender sender) {
    }

    private void initUI() {
        String executeButtonName = this.appContext.getString("execute.algo.button", new Object[0]);
        JButton executeButton = new JButton(executeButtonName);
        executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    CommandExecutionExample.this.executeAlgorithm();
                }
                catch (Exception e) {
                    CommandExecutionExample.this.csdkInterface.handleException(e, (Window)CommandExecutionExample.this.mainFrame);
                }
            }
        });
        executeButton.setEnabled(this.commandContext != null);
        this.mainFrame.add(executeButton);
    }

    protected void executeAlgorithm() throws CommandException, ParameterValueConvertionException {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        parameterValues.put("ARQUIVO_DE_ENTRADA", "arquivos/entrada.txt");
        parameterValues.put("ARQUIVO_DE_SAIDA", "arquivos/saida.txt");
        String algorithmName = "Otimizador";
        String algorithmVersion = "1.0.0";
        AlgorithmTemplate info = new AlgorithmTemplate(algorithmName, algorithmVersion, parameterValues);
        String commandDescription = "execu\u00e7\u00e3o de teste do otimizador";
        String sga = null;
        this.commandContext.executeAlgorithm((IAlgorithmTemplate)info, commandDescription, sga, (Window)this.mainFrame, (ICommandObserver)new CommandObserver());
    }

    private final class CommandObserver
    implements ICommandObserver {
        private CommandObserver() {
        }

        public void onCommandEnd(final ICommandInfo cmdInfo) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ICommandInfo.FinalizationType finalizationType = cmdInfo.getFinalizationType();
                    String message = "Comando finalizado com status " + finalizationType.toString();
                    JOptionPane.showMessageDialog(CommandExecutionExample.this.mainFrame, message);
                }
            });
        }
    }
}

