/*
 * Decompiled with CFR 0.152.
 */
package brickbreaker;

import brickbreaker.Ball;
import brickbreaker.Bat;
import brickbreaker.Bonus;
import brickbreaker.Brick;
import brickbreaker.Config;
import brickbreaker.LevelData;
import brickbreaker.MainController;
import brickbreaker.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class Level
extends Parent {
    private static final double MOB_SCALING = 1.5;
    private final MainController mainController;
    private ArrayList<Brick> bricks;
    private int brickCount;
    private ArrayList<Brick> fadeBricks;
    private ArrayList<Bonus> bonuses;
    private Group group = new Group();
    private ArrayList<Bonus> lives;
    private int catchedBonus;
    private static final int STARTING_LEVEL = 0;
    private static final int BALL_CATCHED = 1;
    private static final int PLAYING = 2;
    private static final int GAME_OVER = 3;
    private int state;
    private int batDirection;
    private double ballDirX;
    private double ballDirY;
    private int levelNumber;
    private Bat bat;
    private Ball ball;
    private Text roundCaption;
    private Text round;
    private Text scoreCaption;
    private Text score;
    private Text livesCaption;
    private ImageView message;
    private Timeline startingTimeline;
    private Timeline timeline;
    private Group infoPanel;

    public Level(int levelNumber, MainController mainController) {
        this.mainController = mainController;
        this.getChildren().add((Object)this.group);
        this.initContent(levelNumber);
    }

    private void initStartingTimeline() {
        this.startingTimeline = new Timeline();
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)500.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Level.this.message.setVisible(true);
                Level.this.state = 0;
                Level.this.bat.setVisible(false);
                Level.this.ball.setVisible(false);
            }
        }, new KeyValue[]{new KeyValue((WritableValue)this.message.opacityProperty(), (Object)0)});
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{new KeyValue((WritableValue)this.message.opacityProperty(), (Object)1)});
        KeyFrame kf3 = new KeyFrame(Duration.millis((double)3000.0), new KeyValue[]{new KeyValue((WritableValue)this.message.opacityProperty(), (Object)1)});
        KeyFrame kf4 = new KeyFrame(Duration.millis((double)4000.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Level.this.message.setVisible(false);
                Level.this.bat.setTranslateX((double)(720 - Level.this.bat.getWidth()) / 2.0);
                Level.this.ball.setTranslateX((double)(720 - Level.this.ball.getDiameter()) / 2.0);
                Level.this.ball.setTranslateY(680 - Level.this.ball.getDiameter());
                Level.this.ballDirX = (double)(Utils.random(2) * 2 - 1) * 2.0;
                Level.this.ballDirY = -6.0;
                Level.this.bat.setVisible(true);
                Level.this.ball.setVisible(true);
                Level.this.state = 1;
            }
        }, new KeyValue[]{new KeyValue((WritableValue)this.message.opacityProperty(), (Object)0)});
        this.startingTimeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf1, kf2, kf3, kf4});
    }

    private void initTimeline() {
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        KeyFrame kf = new KeyFrame(Config.ANIMATION_TIME, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Brick diagBrick;
                int BALL_MAX_X;
                Iterator brickIterator = Level.this.fadeBricks.iterator();
                while (brickIterator.hasNext()) {
                    Brick brick = (Brick)((Object)brickIterator.next());
                    brick.setOpacity(brick.getOpacity() - 0.1);
                    if (!(brick.getOpacity() <= 0.0)) continue;
                    brick.setVisible(false);
                    brickIterator.remove();
                }
                if (Level.this.batDirection != 0 && Level.this.state != 0) {
                    Level.this.moveBat(Level.this.bat.getTranslateX() + (double)Level.this.batDirection);
                }
                Iterator bonusIterator = Level.this.bonuses.iterator();
                while (bonusIterator.hasNext()) {
                    Bonus bonus = (Bonus)((Object)bonusIterator.next());
                    if (bonus.getTranslateY() > 720.0) {
                        bonus.setVisible(false);
                        bonusIterator.remove();
                        Level.this.group.getChildren().remove((Object)bonus);
                        continue;
                    }
                    bonus.setTranslateY(bonus.getTranslateY() + 3.0);
                    if (!(bonus.getTranslateX() + (double)bonus.getWidth() > Level.this.bat.getTranslateX()) || !(bonus.getTranslateX() < Level.this.bat.getTranslateX() + (double)Level.this.bat.getWidth()) || !(bonus.getTranslateY() + (double)bonus.getHeight() > Level.this.bat.getTranslateY()) || !(bonus.getTranslateY() < Level.this.bat.getTranslateY() + (double)Level.this.bat.getHeight())) continue;
                    Level.this.updateScore(100);
                    Level.this.catchedBonus = bonus.getType();
                    bonus.setVisible(false);
                    bonusIterator.remove();
                    Level.this.group.getChildren().remove((Object)bonus);
                    if (bonus.getType() == 0) {
                        Level.this.ballDirX = Level.this.ballDirX / 1.5;
                        Level.this.ballDirY = Level.this.ballDirY / 1.5;
                        Level.this.correctBallSpeed();
                        continue;
                    }
                    if (bonus.getType() == 1) {
                        Level.this.ballDirX = Level.this.ballDirX * 1.5;
                        Level.this.ballDirY = Level.this.ballDirY * 1.5;
                        Level.this.correctBallSpeed();
                        continue;
                    }
                    if (bonus.getType() == 3) {
                        if (Level.this.bat.getSize() >= 7) continue;
                        Level.this.bat.changeSize(Level.this.bat.getSize() + 1);
                        if (!(Level.this.bat.getTranslateX() + (double)Level.this.bat.getWidth() > 720.0)) continue;
                        Level.this.bat.setTranslateX(720 - Level.this.bat.getWidth());
                        continue;
                    }
                    if (bonus.getType() == 4) {
                        if (Level.this.bat.getSize() <= 0) continue;
                        int oldWidth = Level.this.bat.getWidth();
                        Level.this.bat.changeSize(Level.this.bat.getSize() - 1);
                        Level.this.bat.setTranslateX(Level.this.bat.getTranslateX() + (double)((oldWidth - Level.this.bat.getWidth()) / 2));
                        continue;
                    }
                    if (bonus.getType() == 5) {
                        if (Level.this.ball.getSize() >= 5) continue;
                        Level.this.ball.changeSize(Level.this.ball.getSize() + 1);
                        if (Level.this.state != 1) continue;
                        Level.this.ball.setTranslateY(680 - Level.this.ball.getDiameter());
                        continue;
                    }
                    if (bonus.getType() == 6) {
                        if (Level.this.ball.getSize() <= 0) continue;
                        Level.this.ball.changeSize(Level.this.ball.getSize() - 1);
                        if (Level.this.state != 1) continue;
                        Level.this.ball.setTranslateY(680 - Level.this.ball.getDiameter());
                        continue;
                    }
                    if (bonus.getType() != 8) continue;
                    Level.this.mainController.increaseLives();
                    Level.this.updateLives();
                }
                if (Level.this.state != 2) {
                    return;
                }
                double newX = Level.this.ball.getTranslateX() + Level.this.ballDirX;
                double newY = Level.this.ball.getTranslateY() + Level.this.ballDirY;
                boolean inverseX = false;
                boolean inverseY = false;
                if (newX < 0.0) {
                    newX = -newX;
                    inverseX = true;
                }
                if (newX > (double)(BALL_MAX_X = 720 - Level.this.ball.getDiameter())) {
                    newX = (double)BALL_MAX_X - (newX - (double)BALL_MAX_X);
                    inverseX = true;
                }
                if (newY < 0.0) {
                    newY = 0.0 - newY;
                    inverseY = true;
                }
                if (Level.this.ballDirY > 0.0 && Level.this.ball.getTranslateY() + (double)Level.this.ball.getDiameter() < 680.0 && newY + (double)Level.this.ball.getDiameter() >= 680.0 && newX >= Level.this.bat.getTranslateX() - (double)Level.this.ball.getDiameter() && newX < Level.this.bat.getTranslateX() + (double)Level.this.bat.getWidth() + (double)Level.this.ball.getDiameter()) {
                    inverseY = true;
                    double speed = Math.sqrt(Level.this.ballDirX * Level.this.ballDirX + Level.this.ballDirY * Level.this.ballDirY);
                    Level.this.ballDirX = Level.this.ballDirX * ((speed + 0.5) / speed);
                    Level.this.ballDirY = Level.this.ballDirY * ((speed + 0.5) / speed);
                    double offsetX = newX + (double)(Level.this.ball.getDiameter() / 2) - Level.this.bat.getTranslateX() - (double)(Level.this.bat.getWidth() / 2);
                    if (Math.abs(offsetX) > (double)(Level.this.bat.getWidth() / 4)) {
                        Level.this.ballDirX = Level.this.ballDirX + offsetX / 5.0;
                        double MAX_COORD_SPEED = Math.sqrt(speed * speed - 4.0);
                        if (Math.abs(Level.this.ballDirX) > MAX_COORD_SPEED) {
                            Level.this.ballDirX = (double)Utils.sign(Level.this.ballDirX) * MAX_COORD_SPEED;
                        }
                        Level.this.ballDirY = (double)Utils.sign(Level.this.ballDirY) * Math.sqrt(speed * speed - Level.this.ballDirX * Level.this.ballDirX);
                    }
                    Level.this.correctBallSpeed();
                    if (Level.this.catchedBonus == 2) {
                        newY = 680 - Level.this.ball.getDiameter();
                        Level.this.state = 1;
                    }
                }
                int firstCol = (int)(newX / 48.0);
                int secondCol = (int)((newX + (double)Level.this.ball.getDiameter()) / 48.0);
                int firstRow = (int)((newY - 0.0) / 24.0);
                int secondRow = (int)((newY - 0.0 + (double)Level.this.ball.getDiameter()) / 24.0);
                if (Level.this.ballDirX > 0.0) {
                    int temp = secondCol;
                    secondCol = firstCol;
                    firstCol = temp;
                }
                if (Level.this.ballDirY > 0.0) {
                    int temp = secondRow;
                    secondRow = firstRow;
                    firstRow = temp;
                }
                Brick vertBrick = Level.this.getBrick(firstRow, secondCol);
                Brick horBrick = Level.this.getBrick(secondRow, firstCol);
                if (vertBrick != null) {
                    Level.this.kickBrick(firstRow, secondCol);
                    if (Level.this.catchedBonus != 7) {
                        inverseY = true;
                    }
                }
                if (horBrick != null && (firstCol != secondCol || firstRow != secondRow)) {
                    Level.this.kickBrick(secondRow, firstCol);
                    if (Level.this.catchedBonus != 7) {
                        inverseX = true;
                    }
                }
                if ((firstCol != secondCol || firstRow != secondRow) && (diagBrick = Level.this.getBrick(firstRow, firstCol)) != null && diagBrick != vertBrick && diagBrick != horBrick) {
                    Level.this.kickBrick(firstRow, firstCol);
                    if (vertBrick == null && horBrick == null && Level.this.catchedBonus != 7) {
                        inverseX = true;
                        inverseY = true;
                    }
                }
                Level.this.ball.setTranslateX(newX);
                Level.this.ball.setTranslateY(newY);
                if (inverseX) {
                    Level.this.ballDirX = -Level.this.ballDirX;
                }
                if (inverseY) {
                    Level.this.ballDirY = -Level.this.ballDirY;
                }
                if (Level.this.ball.getTranslateY() > 720.0) {
                    Level.this.lostLife();
                }
            }
        }, new KeyValue[0]);
        this.timeline.getKeyFrames().add((Object)kf);
    }

    public void start() {
        this.startingTimeline.play();
        this.timeline.play();
        ((Node)this.group.getChildren().get(0)).requestFocus();
        this.updateScore(0);
        this.updateLives();
    }

    public void stop() {
        this.startingTimeline.stop();
        this.timeline.stop();
    }

    private void initLevel() {
        String[] level = LevelData.getLevelData(this.levelNumber);
        for (int row = 0; row < level.length; ++row) {
            for (int col = 0; col < 15; ++col) {
                String type;
                String rowString = level[row];
                Brick brick = null;
                if (rowString != null && col < rowString.length() && !(type = rowString.substring(col, col + 1)).equals(" ")) {
                    brick = new Brick(Brick.getBrickType(type));
                    brick.setTranslateX(col * 48);
                    brick.setTranslateY(0 + row * 24);
                    if (brick.getType() != 6) {
                        ++this.brickCount;
                    }
                }
                this.bricks.add(brick);
            }
        }
    }

    private Brick getBrick(int row, int col) {
        int i = row * 15 + col;
        if (col < 0 || col >= 15 || row < 0 || i >= this.bricks.size()) {
            return null;
        }
        return this.bricks.get(i);
    }

    private void updateScore(int inc) {
        this.mainController.setScore(this.mainController.getScore() + inc);
        this.score.setText(this.mainController.getScore() + "");
    }

    private void moveBat(double newX) {
        double x = newX;
        if (x < 0.0) {
            x = 0.0;
        }
        if (x + (double)this.bat.getWidth() > 720.0) {
            x = 720 - this.bat.getWidth();
        }
        if (this.state == 1) {
            double BALL_MAX_X;
            double ballX = this.ball.getTranslateX() + x - this.bat.getTranslateX();
            if (ballX < 0.0) {
                ballX = 0.0;
            }
            if (ballX > (BALL_MAX_X = (double)(720 - this.ball.getDiameter()))) {
                ballX = BALL_MAX_X;
            }
            this.ball.setTranslateX(ballX);
        }
        this.bat.setTranslateX(x);
    }

    private void kickBrick(int row, int col) {
        Brick brick = this.getBrick(row, col);
        if (brick == null || this.catchedBonus != 7 && !brick.kick()) {
            return;
        }
        this.updateScore(10);
        if (brick.getType() != 6) {
            --this.brickCount;
            if (this.brickCount == 0) {
                this.mainController.changeState(this.mainController.getState() + 1);
            }
        }
        this.bricks.set(row * 15 + col, null);
        this.fadeBricks.add(brick);
        if (Utils.random(8) == 0 && this.bonuses.size() < 5) {
            Bonus bonus = new Bonus(Utils.random(9));
            bonus.setTranslateY(brick.getTranslateY());
            bonus.setVisible(true);
            bonus.setTranslateX(brick.getTranslateX() + (double)((48 - bonus.getWidth()) / 2));
            this.group.getChildren().add((Object)bonus);
            this.bonuses.add(bonus);
        }
    }

    private void updateLives() {
        while (this.lives.size() > this.mainController.getLifeCount()) {
            Bonus lifeBat = this.lives.get(this.lives.size() - 1);
            this.lives.remove((Object)lifeBat);
            this.infoPanel.getChildren().remove((Object)lifeBat);
        }
        int maxVisibleLifes = 9;
        double scale = 0.8;
        for (int life = this.lives.size(); life < Math.min(this.mainController.getLifeCount(), maxVisibleLifes); ++life) {
            Bonus lifeBonus = new Bonus(8);
            lifeBonus.setScaleX(scale);
            lifeBonus.setScaleY(scale);
            lifeBonus.setTranslateX(this.livesCaption.getTranslateX() + this.livesCaption.getBoundsInLocal().getWidth() + (double)(life % 3 * lifeBonus.getWidth()));
            lifeBonus.setTranslateY(this.livesCaption.getTranslateY() + (double)(life / 3 * lifeBonus.getHeight()) * 1.5);
            this.lives.add(lifeBonus);
            this.infoPanel.getChildren().add((Object)lifeBonus);
        }
    }

    private void correctBallSpeed() {
        double speed = Math.sqrt(this.ballDirX * this.ballDirX + this.ballDirY * this.ballDirY);
        if (speed > 24.0) {
            this.ballDirX *= 24.0 / speed;
            this.ballDirY *= 24.0 / speed;
            speed = 24.0;
        }
        if (speed < 6.0) {
            this.ballDirX *= 6.0 / speed;
            this.ballDirY *= 6.0 / speed;
            speed = 6.0;
        }
        if (Math.abs(this.ballDirX) < 2.0) {
            this.ballDirX = (double)Utils.sign(this.ballDirX) * 2.0;
            this.ballDirY = (double)Utils.sign(this.ballDirY) * Math.sqrt(speed * speed - this.ballDirX * this.ballDirX);
        } else if (Math.abs(this.ballDirY) < 2.0) {
            this.ballDirY = (double)Utils.sign(this.ballDirY) * 2.0;
            this.ballDirX = (double)Utils.sign(this.ballDirX) * Math.sqrt(speed * speed - this.ballDirY * this.ballDirY);
        }
    }

    private void lostLife() {
        this.mainController.decreaseLives();
        if (this.mainController.getLifeCount() < 0) {
            this.state = 3;
            this.ball.setVisible(false);
            this.bat.setVisible(false);
            this.message.setImage((Image)Config.getImages().get(21));
            this.message.setTranslateX((720.0 - this.message.getImage().getWidth()) / 2.0);
            this.message.setTranslateY(0.0 + (720.0 - this.message.getImage().getHeight()) / 2.0);
            this.message.setVisible(true);
            this.message.setOpacity(1.0);
        } else {
            this.updateLives();
            this.bat.changeSize(2);
            this.ball.changeSize(2);
            this.bat.setTranslateX((720 - this.bat.getWidth()) / 2);
            this.ball.setTranslateX(360 - this.ball.getDiameter() / 2);
            this.ball.setTranslateY(680 - this.ball.getDiameter());
            this.state = 1;
            this.catchedBonus = 0;
            this.ballDirX = (double)(Utils.random(2) * 2 - 1) * 2.0;
            this.ballDirY = -6.0;
        }
    }

    private void initInfoPanel() {
        this.infoPanel = new Group();
        this.roundCaption = new Text();
        this.roundCaption.setText("ROUND");
        this.roundCaption.setTextOrigin(VPos.TOP);
        this.roundCaption.setFill((Paint)Color.rgb((int)51, (int)102, (int)51));
        Font f = new Font("Impact", 18.0);
        this.roundCaption.setFont(f);
        this.roundCaption.setTranslateX(30.0);
        this.roundCaption.setTranslateY(128.0);
        this.round = new Text();
        this.round.setTranslateX(this.roundCaption.getTranslateX() + this.roundCaption.getBoundsInLocal().getWidth() + 10.0);
        this.round.setTranslateY(this.roundCaption.getTranslateY());
        this.round.setText(this.levelNumber + "");
        this.round.setTextOrigin(VPos.TOP);
        this.round.setFont(f);
        this.round.setFill((Paint)Color.rgb((int)0, (int)204, (int)102));
        this.scoreCaption = new Text();
        this.scoreCaption.setText("SCORE");
        this.scoreCaption.setFill((Paint)Color.rgb((int)51, (int)102, (int)51));
        this.scoreCaption.setTranslateX(30.0);
        this.scoreCaption.setTranslateY(164.0);
        this.scoreCaption.setTextOrigin(VPos.TOP);
        this.scoreCaption.setFont(f);
        this.score = new Text();
        this.score.setTranslateX(this.scoreCaption.getTranslateX() + this.scoreCaption.getBoundsInLocal().getWidth() + 10.0);
        this.score.setTranslateY(this.scoreCaption.getTranslateY());
        this.score.setFill((Paint)Color.rgb((int)0, (int)204, (int)102));
        this.score.setTextOrigin(VPos.TOP);
        this.score.setFont(f);
        this.score.setText("");
        this.livesCaption = new Text();
        this.livesCaption.setText("LIFE");
        this.livesCaption.setTranslateX(30.0);
        this.livesCaption.setTranslateY(200.0);
        this.livesCaption.setFill((Paint)Color.rgb((int)51, (int)102, (int)51));
        this.livesCaption.setTextOrigin(VPos.TOP);
        this.livesCaption.setFont(f);
        Color INFO_LEGEND_COLOR = Color.rgb((int)0, (int)114, (int)188);
        int infoWidth = 240;
        Rectangle black = new Rectangle();
        black.setWidth((double)infoWidth);
        black.setHeight(720.0);
        black.setFill((Paint)Color.BLACK);
        ImageView verLine = new ImageView();
        verLine.setImage(new Image(Level.class.getResourceAsStream("images/desktop/vline.png")));
        verLine.setTranslateX(3.0);
        ImageView logo = new ImageView();
        logo.setImage((Image)Config.getImages().get(10));
        logo.setTranslateX(30.0);
        logo.setTranslateY(30.0);
        Text legend = new Text();
        legend.setTranslateX(30.0);
        legend.setTranslateY(310.0);
        legend.setText("LEGEND");
        legend.setFill((Paint)INFO_LEGEND_COLOR);
        legend.setTextOrigin(VPos.TOP);
        legend.setFont(new Font("Impact", 18.0));
        this.infoPanel.getChildren().addAll((Object[])new Node[]{black, verLine, logo, this.roundCaption, this.round, this.scoreCaption, this.score, this.livesCaption, legend});
        for (int i = 0; i < 9; ++i) {
            Bonus bonus = new Bonus(i);
            Text text = new Text();
            text.setTranslateX(100.0);
            text.setTranslateY((double)(350 + i * 40));
            text.setText(Bonus.NAMES[i]);
            text.setFill((Paint)INFO_LEGEND_COLOR);
            text.setTextOrigin(VPos.TOP);
            text.setFont(new Font("Arial", 12.0));
            bonus.setTranslateX(30 + (70 - bonus.getWidth()) / 2);
            bonus.setTranslateY(text.getTranslateY() - ((double)bonus.getHeight() - text.getBoundsInLocal().getHeight()) / 2.0);
            this.infoPanel.getChildren().addAll((Object[])new Node[]{bonus, text});
        }
        this.infoPanel.setTranslateX(720.0);
    }

    private void initContent(int level) {
        this.catchedBonus = 0;
        this.state = 0;
        this.batDirection = 0;
        this.levelNumber = level;
        this.lives = new ArrayList();
        this.bricks = new ArrayList();
        this.fadeBricks = new ArrayList();
        this.bonuses = new ArrayList();
        this.ball = new Ball();
        this.ball.setVisible(false);
        this.bat = new Bat();
        this.bat.setTranslateY(680.0);
        this.bat.setVisible(false);
        this.message = new ImageView();
        this.message.setImage((Image)Config.getImages().get(20));
        this.message.setTranslateX((720.0 - this.message.getImage().getWidth()) / 2.0);
        this.message.setTranslateY(0.0 + (720.0 - this.message.getImage().getHeight()) / 2.0);
        this.message.setVisible(false);
        this.initLevel();
        this.initStartingTimeline();
        this.initTimeline();
        this.initInfoPanel();
        ImageView background = new ImageView();
        background.setFocusTraversable(true);
        background.setImage((Image)Config.getImages().get(0));
        background.setFitWidth(960.0);
        background.setFitHeight(720.0);
        background.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                Level.this.moveBat(me.getX() - (double)(Level.this.bat.getWidth() / 2));
            }
        });
        background.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                Level.this.moveBat(me.getX() - (double)(Level.this.bat.getWidth() / 2));
            }
        });
        background.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                if (Level.this.state == 2) {
                    Level.this.moveBat(me.getX() - (double)(Level.this.bat.getWidth() / 2));
                }
                if (Level.this.state == 1) {
                    Level.this.state = 2;
                }
                if (Level.this.state == 3) {
                    Level.this.mainController.changeState(0);
                }
            }
        });
        background.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (Level.this.state == 1 && (ke.getCode() == KeyCode.SPACE || ke.getCode() == KeyCode.ENTER || ke.getCode() == KeyCode.PLAY)) {
                    Level.this.state = 2;
                }
                if (Level.this.state == 3) {
                    Level.this.mainController.changeState(0);
                }
                if (Level.this.state == 2 && ke.getCode() == KeyCode.Q) {
                    Level.this.lostLife();
                    return;
                }
                if (ke.getCode() == KeyCode.LEFT || ke.getCode() == KeyCode.TRACK_PREV) {
                    Level.this.batDirection = -8;
                }
                if (ke.getCode() == KeyCode.RIGHT || ke.getCode() == KeyCode.TRACK_NEXT) {
                    Level.this.batDirection = 8;
                }
            }
        });
        background.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode() == KeyCode.LEFT || ke.getCode() == KeyCode.RIGHT || ke.getCode() == KeyCode.TRACK_PREV || ke.getCode() == KeyCode.TRACK_NEXT) {
                    Level.this.batDirection = 0;
                }
            }
        });
        this.group.getChildren().add((Object)background);
        for (int row = 0; row < this.bricks.size() / 15; ++row) {
            for (int col = 0; col < 15; ++col) {
                Brick b = this.getBrick(row, col);
                if (b == null) continue;
                this.group.getChildren().add((Object)b);
            }
        }
        this.group.getChildren().addAll((Object[])new Node[]{this.message, this.ball, this.bat, this.infoPanel});
    }
}

