package brickbreaker;

import java.net.MalformedURLException;

import javax.swing.JFrame;

import csdk.v2.fx.helper.AbstractJFXApplication;
import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.core.ICSDKEnvironment;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;

public class FXApplication extends AbstractJFXApplication {

  private MainController controlApp;

  /**
   * Construtor.
   */

  public FXApplication(ICSDKEnvironment csdkInterface)
    throws MalformedURLException {
    super(csdkInterface);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationName() {
    return "Brick Breaker";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void applicationStarted(JFrame mainFrame)
    throws ApplicationException {
    mainFrame.setSize(Config.SCREEN_WIDTH + 2 * Config.WINDOW_BORDER,
      Config.SCREEN_HEIGHT + 2 * Config.WINDOW_BORDER
        + Config.TITLE_BAR_HEIGHT);
    mainFrame.setResizable(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void applicationEnded() throws ApplicationException {
    // vazio
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Parent getParentNode() throws Exception {
    Config.initialize();
    Group root = new Group();
    controlApp = new MainController(root);
    controlApp.changeState(MainController.SPLASH);
    return root;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void configStyle(Scene scene) {
    scene.setFill(Color.BLACK);
  }

  /**
   * @return controlador
   */
  public MainController getMainController() {
    return controlApp;
  }

}
