/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.util.BitSet;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.table.FooterCell;

public class LargeColumnModel
implements TableModel {
    static final int START_JOIN_COLUMN = 0;
    private TableModel model;
    private int largeCol;
    private BitSet insertedRows;

    public LargeColumnModel(TableModel model, int largeCol) {
        this.model = model;
        this.largeCol = largeCol;
        this.insertedRows = new BitSet();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.model.addTableModelListener(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.model.getColumnClass(this.getModelColumnIndex(columnIndex));
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount() - 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(this.getModelColumnIndex(columnIndex));
    }

    @Override
    public int getRowCount() {
        int rowCount = this.model.getRowCount();
        this.insertedRows.clear();
        for (int row = 0; row < rowCount; ++row) {
            Object value = this.model.getValueAt(row, this.largeCol);
            if (FooterCell.class.isInstance(value)) {
                value = ((FooterCell)FooterCell.class.cast(value)).getValue();
            }
            if (value == null || value.equals("")) continue;
            this.insertedRows.set(row + 1 + this.insertedRows.cardinality());
        }
        return rowCount + this.insertedRows.cardinality();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int col = this.getModelColumnIndex(rowIndex, columnIndex);
        if (col == -1) {
            return null;
        }
        int row = this.getModelRowIndex(rowIndex);
        Object value = this.model.getValueAt(row, col);
        if (FooterCell.class.isInstance(value)) {
            value = ((FooterCell)FooterCell.class.cast(value)).getValue();
        }
        if (col == this.largeCol) {
            value = "   " + this.model.getColumnName(col) + ": " + value;
        }
        return value;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int col = this.getModelColumnIndex(rowIndex, columnIndex);
        if (col == -1) {
            return false;
        }
        int row = this.getModelRowIndex(rowIndex);
        return this.model.isCellEditable(row, col);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.model.removeTableModelListener(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int col = this.getModelColumnIndex(rowIndex, columnIndex);
        if (col == -1) {
            return;
        }
        int row = this.getModelRowIndex(rowIndex);
        this.model.setValueAt(aValue, row, col);
    }

    public BitSet getInsertedRows() {
        return this.insertedRows;
    }

    public int getLargeCol() {
        return this.largeCol;
    }

    private int getModelColumnIndex(int columnIndex) {
        return columnIndex < this.largeCol ? columnIndex : columnIndex + 1;
    }

    int getViewColumnIndex(int columnIndex) {
        if (columnIndex == this.largeCol) {
            return -1;
        }
        return columnIndex < this.largeCol ? columnIndex : columnIndex - 1;
    }

    private int getModelColumnIndex(int rowIndex, int columnIndex) {
        int col;
        int n = col = columnIndex < this.largeCol ? columnIndex : columnIndex + 1;
        if (!this.insertedRows.get(rowIndex)) {
            return col;
        }
        if (columnIndex == 0) {
            return this.largeCol;
        }
        return -1;
    }

    private int getModelRowIndex(int rowIndex) {
        int addedRows = this.insertedRows.get(0, rowIndex + 1).cardinality();
        return rowIndex - addedRows;
    }

    int getViewRowIndex(int rowIndex) {
        int viewRowIndex = rowIndex;
        int row = this.insertedRows.nextSetBit(0);
        while (row >= 0) {
            if (row - 1 > viewRowIndex) {
                return viewRowIndex;
            }
            ++viewRowIndex;
            row = this.insertedRows.nextSetBit(row + 1);
        }
        return viewRowIndex;
    }
}

