/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.wizard;

import java.util.HashMap;
import java.util.Map;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.StepListener;
import tecgraf.javautils.gui.wizard.Wizard;
import tecgraf.javautils.gui.wizard.WizardException;
import tecgraf.javautils.gui.wizard.WizardListener;

public final class History
implements WizardListener,
StepListener {
    private Map mapSteps;
    private Map global;
    private Object result;
    private boolean wasGonePrevious;
    private Wizard wizard;
    private boolean resetHistoryOnChange;

    public void add(Step step, String name, Object information) {
        if (step == null) {
            throw new IllegalArgumentException("O passo n\u00e3o pode ser nulo.");
        }
        this.get(step).put(name, information);
    }

    public boolean contains(Step step, String name) {
        for (Step currentStep = step; currentStep != null; currentStep = currentStep.getPrevious()) {
            if (!this.get(currentStep).containsKey(name)) continue;
            return true;
        }
        return this.global.containsKey(name);
    }

    public Object get(Step step, String name) {
        if (name == null) {
            throw new IllegalArgumentException("O nome do dado n\u00e3o pode ser nulo.");
        }
        for (Step currentStep = step; currentStep != null; currentStep = currentStep.getPrevious()) {
            if (!this.get(currentStep).containsKey(name)) continue;
            return this.get(currentStep).get(name);
        }
        return this.global.get(name);
    }

    public Object getResult() {
        return this.result;
    }

    public void remove(Step step, String name) {
        for (Step currentStep = step; currentStep != null; currentStep = currentStep.getPrevious()) {
            if (!this.get(currentStep).containsKey(name)) continue;
            this.get(currentStep).remove(name);
        }
    }

    @Override
    public void wasCancelled(Step step) {
        this.clear();
    }

    @Override
    public void wasClosed(Step step) {
        this.clear();
    }

    @Override
    public void wasConfirmed(Step step, Object object) {
    }

    @Override
    public void wasGoneNext(Step step, History history) {
        this.wasGonePrevious = false;
    }

    @Override
    public void wasGonePrevious(Step step, History history) {
        this.wasGonePrevious = true;
    }

    @Override
    public void wasHappenedException(Step step, WizardException exception) {
        this.clear();
    }

    void clear(Step step) {
        Map map = this.get(step);
        map.clear();
    }

    public void addGlobal(String key, Object datum) {
        if (key == null) {
            throw new IllegalArgumentException("A chave n\u00e3o pode ser nula.");
        }
        if (datum == null) {
            throw new IllegalArgumentException("O dado n\u00e3o pode ser nulo.");
        }
        this.global.put(key, datum);
    }

    public void addGlobal(Map<?, ?> globalData) {
        if (globalData == null) {
            throw new IllegalArgumentException("O mapa de dados globais n\u00e3o pode ser nulo.");
        }
        for (String key : globalData.keySet()) {
            this.addGlobal(key, globalData.get(key));
        }
    }

    void setResult(Object result) {
        if (result == null) {
            throw new IllegalArgumentException("O resultado n\u00e3o pode ser nulo.");
        }
        this.result = result;
    }

    private void clear() {
        this.mapSteps.clear();
        this.global.clear();
    }

    public void clearGlobalData() {
        this.global.clear();
    }

    private Map get(Step step) {
        Map map;
        if (this.mapSteps.containsKey(step)) {
            map = (Map)this.mapSteps.get(step);
        } else {
            map = new HashMap();
            this.mapSteps.put(step, map);
        }
        return map;
    }

    private void reset(Class<?> stepClass) {
        Step step = this.wizard.getStep(stepClass);
        while (step != null) {
            this.clear(step);
            step = this.wizard.getStep(step.getNext(this));
        }
    }

    @Override
    public final void wasChanged(Step step) {
        if (this.wasGonePrevious && this.resetHistoryOnChange) {
            this.reset(step.getClass());
        }
    }

    public History(Wizard wizard, boolean resetHistoryOnChange) {
        this.resetHistoryOnChange = resetHistoryOnChange;
        this.wizard = wizard;
        this.mapSteps = new HashMap();
        this.global = new HashMap();
        this.result = null;
    }
}

