/*
 * Decompiled with CFR 0.152.
 */
package snakegame;

import java.awt.Component;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import snakegame.exception.GameOverException;
import snakegame.exception.VictoryException;
import snakegame.map.SnakeTableModel;
import snakegame.session.Mode;
import snakegame.session.Session;
import tecgraf.javautils.gui.StandardDialogs;

public class MoveTask
extends TimerTask {
    private Session session;
    private Timer timer;
    private SnakeTableModel model;
    private JFrame frame;

    public MoveTask(Session session, Timer timer, SnakeTableModel model, JFrame frame) {
        if (session == null) {
            throw new IllegalArgumentException("session n\u00e3o pode ser nulo.");
        }
        if (timer == null) {
            throw new IllegalArgumentException("timer n\u00e3o pode ser nulo.");
        }
        if (model == null) {
            throw new IllegalArgumentException("model n\u00e3o pode ser nulo.");
        }
        if (frame == null) {
            throw new IllegalArgumentException("frame n\u00e3o pode ser nulo.");
        }
        this.session = session;
        this.timer = timer;
        this.model = model;
        this.frame = frame;
    }

    @Override
    public void run() {
        try {
            this.model.move();
            SwingUtilities.invokeLater(() -> this.model.fireTableDataChanged());
        }
        catch (GameOverException e) {
            this.timer.cancel();
            this.session.setMode(Mode.OFF);
            StandardDialogs.showErrorDialog((Component)this.frame, (String)this.frame.getTitle(), (String)e.getMessage());
        }
        catch (VictoryException e) {
            this.timer.cancel();
            this.session.setMode(Mode.OFF);
            StandardDialogs.showInfoDialog((Component)this.frame, (String)this.frame.getTitle(), (Object)e.getMessage());
        }
    }
}

