/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableReportItem;

public class PrintableImage
implements PrintableReportItem,
ImageObserver {
    private ImageIcon image;
    private float height;
    private boolean done;
    private HorizontalAlignment alignment;

    public PrintableImage(ImageIcon image, HorizontalAlignment alignment) {
        this.image = image;
        this.alignment = alignment;
    }

    @Override
    public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
        return true;
    }

    @Override
    public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
        this.height = this.image.getIconHeight();
        int x = (int)format.getImageableX();
        switch (this.alignment) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                x += (int)format.getImageableWidth() - this.image.getIconWidth();
                break;
            }
            case CENTER: {
                x += ((int)format.getImageableWidth() - this.image.getIconWidth()) / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("alignment " + (Object)((Object)this.alignment) + " desconhecido.");
            }
        }
        int y = (int)format.getImageableY();
        this.drawImage(this.image, g2, x, y);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage(ImageIcon image, Graphics2D g2, int x, int y) {
        int height = image.getIconHeight();
        int width = image.getIconWidth();
        Image img = image.getImage();
        this.done = false;
        boolean drawn = g2.drawImage(img, x, y, width, height, this);
        if (!drawn) {
            while (true) {
                PrintableImage printableImage = this;
                synchronized (printableImage) {
                    if (this.done) {
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.done = (infoflags & 0x70) != 0;
        return !this.done;
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
    }

    @Override
    public float getWidth() {
        return this.image.getIconWidth();
    }

    public static enum HorizontalAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

