/*
 * Decompiled with CFR 0.152.
 */
package snakegame.algorithm.util;

import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import snakegame.map.Direction;

public class Util {
    public static Point lookahead(List<Point> snake, Direction direction, int rows, int columns) {
        int x = snake.get((int)0).x;
        int y = snake.get((int)0).y;
        switch (direction) {
            case UP: {
                --x;
                break;
            }
            case DOWN: {
                ++x;
                break;
            }
            case LEFT: {
                --y;
                break;
            }
            case RIGHT: {
                ++y;
            }
        }
        if (x < 0 || x == rows || y < 0 || y == columns) {
            return null;
        }
        Point point = new Point(x, y);
        if (snake.contains(point)) {
            return null;
        }
        return point;
    }

    public static List<Direction> whereIsTheFood(Point head, Point food) {
        LinkedList<Direction> result = new LinkedList<Direction>();
        if (food.x < head.x) {
            result.add(Direction.UP);
        }
        if (food.x > head.x) {
            result.add(Direction.DOWN);
        }
        if (food.y < head.y) {
            result.add(Direction.LEFT);
        }
        if (food.y > head.y) {
            result.add(Direction.RIGHT);
        }
        return result;
    }

    public static boolean isOpposite(Direction a, Direction b) {
        switch (a) {
            case UP: {
                return b == Direction.DOWN;
            }
            case DOWN: {
                return b == Direction.UP;
            }
            case LEFT: {
                return b == Direction.RIGHT;
            }
            case RIGHT: {
                return b == Direction.LEFT;
            }
        }
        return false;
    }
}

