/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;

public class ExpandablePanel
extends JPanel {
    public static final String EXPAND_ACTION_ID = "expand";
    public static final String COLLAPSE_ACTION_ID = "colLapse";
    public static final int LEFT_INSET = GUIResources.BUTTON_EXPAND_ICON.getIconWidth() + 12;
    private boolean isExpanded = false;
    private JButton controlButton;
    private JLabel panelTitle;
    private ActionListener listener = null;
    private final JPanel contentPanel;

    static void makeButtonTransparent(JButton button) {
        ExpandablePanel.makeButtonTransparent(button, new Insets(0, 0, 0, 0));
    }

    static void makeButtonTransparent(JButton button, Insets margins) {
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setMargin(margins);
        button.setFocusPainted(false);
    }

    public static boolean isExpandEvent(ActionEvent event) {
        return event.getActionCommand().equals(EXPAND_ACTION_ID);
    }

    public ExpandablePanel(String title, Position controlPosition) {
        this(title, controlPosition, false, false);
    }

    public ExpandablePanel(String title, Position controlPosition, boolean showSeparator, boolean identLeft) {
        this(title, showSeparator, controlPosition, identLeft, new GridBagLayout());
    }

    public ExpandablePanel(String title, boolean showSeparator, Position controlPosition, boolean identLeft, LayoutManager layout) {
        super.setLayout(new GridBagLayout());
        this.contentPanel = new JPanel(layout);
        this.contentPanel.setVisible(this.isExpanded);
        this.controlButton = new JButton(new AbstractAction(null, GUIResources.BUTTON_EXPAND_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandablePanel.this.isExpanded = !ExpandablePanel.this.isExpanded;
                ExpandablePanel.this.stateChanged(true, true);
            }
        });
        ExpandablePanel.makeButtonTransparent(this.controlButton);
        JPanel headerPanel = new JPanel(new GridBagLayout());
        int vOffset = 0;
        if (showSeparator) {
            headerPanel.add((Component)new JSeparator(), new GBC(0, vOffset++).horizontal().bottom(3).width(2));
        }
        this.panelTitle = new JLabel(title);
        switch (controlPosition) {
            case CONTROL_LEFT: {
                headerPanel.add((Component)this.controlButton, new GBC(0, vOffset).right(5));
                headerPanel.add((Component)this.panelTitle, new GBC(1, vOffset++).west().horizontal());
                break;
            }
            case CONTROL_RIGHTMOST: {
                headerPanel.add((Component)this.panelTitle, new GBC(0, vOffset).west().horizontal());
                headerPanel.add((Component)this.controlButton, new GBC(1, vOffset++).east().right(0).left(5));
                break;
            }
            case CONTROL_RIGHT: {
                headerPanel.add((Component)this.panelTitle, new GBC(0, vOffset).west());
                headerPanel.add((Component)this.controlButton, new GBC(1, vOffset++).west().right(0).left(5).pushx());
                break;
            }
            default: {
                throw new AssertionError((Object)("posicionamento desconhecido: " + controlPosition.name()));
            }
        }
        super.addImpl(headerPanel, new GBC(0, 0).northwest().horizontal(), -1);
        GBC gbc = new GBC(0, 1).northwest().both();
        if (identLeft) {
            gbc.left(LEFT_INSET);
        }
        super.addImpl(this.contentPanel, gbc, -1);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean setExpanded(boolean expanded, boolean notifyParent, boolean notifyListener) {
        if (expanded != this.isExpanded) {
            this.isExpanded = expanded;
            this.stateChanged(notifyParent, notifyListener);
            return true;
        }
        return false;
    }

    public boolean setExpanded(boolean expanded) {
        return this.setExpanded(expanded, true, true);
    }

    private void stateChanged(boolean notifyParent, boolean notifyListener) {
        this.contentPanel.setVisible(this.isExpanded);
        this.controlButton.setIcon(this.isExpanded ? GUIResources.BUTTON_COLLAPSE_ICON : GUIResources.BUTTON_EXPAND_ICON);
        if (this.getParent() != null) {
            this.adjustParent(notifyParent);
            if (notifyListener && this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, (int)System.currentTimeMillis(), this.isExpanded ? EXPAND_ACTION_ID : COLLAPSE_ACTION_ID));
            }
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.contentPanel.add(comp, constraints, index);
    }

    @Override
    public void remove(int index) {
        this.contentPanel.remove(index);
    }

    @Override
    public void remove(Component comp) {
        this.contentPanel.remove(comp);
    }

    @Override
    public void removeAll() {
        this.contentPanel.removeAll();
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.contentPanel == null) {
            return;
        }
        this.contentPanel.setLayout(layout);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.controlButton.setEnabled(enabled);
        this.panelTitle.setEnabled(enabled);
        for (Component child : this.contentPanel.getComponents()) {
            child.setEnabled(enabled);
        }
    }

    public ExpandablePanel setTitle(String title) {
        this.panelTitle.setText(title);
        this.adjustParent(true);
        return this;
    }

    private void adjustParent(boolean notifyParent) {
        Container parent = this.getParent();
        if (parent != null && parent.isShowing()) {
            this.revalidate();
            if (notifyParent) {
                parent.repaint();
            }
        }
    }

    public ActionListener setListener(ActionListener newListener) {
        ActionListener oldListener = this.listener;
        this.listener = newListener;
        return oldListener;
    }

    public ActionListener removeListener() {
        return this.setListener(null);
    }

    public static enum Position {
        CONTROL_LEFT,
        CONTROL_RIGHT,
        CONTROL_RIGHTMOST;

    }
}

